/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.client.serialization.model.DTO;
import org.mockserver.client.serialization.model.HttpClassCallbackDTO;
import org.mockserver.client.serialization.model.HttpErrorDTO;
import org.mockserver.client.serialization.model.HttpForwardDTO;
import org.mockserver.client.serialization.model.HttpObjectCallbackDTO;
import org.mockserver.client.serialization.model.HttpRequestDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.client.serialization.model.HttpTemplateDTO;
import org.mockserver.client.serialization.model.TimeToLiveDTO;
import org.mockserver.client.serialization.model.TimesDTO;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.ObjectWithJsonToString;

public class ExpectationDTO
extends ObjectWithJsonToString
implements DTO<Expectation> {
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;
    private HttpTemplateDTO httpResponseTemplate;
    private HttpForwardDTO httpForward;
    private HttpTemplateDTO httpForwardTemplate;
    private HttpErrorDTO httpError;
    private HttpClassCallbackDTO httpClassCallback;
    private HttpObjectCallbackDTO httpObjectCallback;
    private TimesDTO times;
    private TimeToLiveDTO timeToLive;

    public ExpectationDTO(Expectation expectation) {
        if (expectation != null) {
            TimeToLive timeToLive;
            Times times;
            HttpObjectCallback httpObjectCallback;
            HttpClassCallback httpClassCallback;
            HttpError httpError;
            HttpTemplate httpForwardTemplate;
            HttpForward httpForward;
            HttpTemplate httpResponseTemplate;
            HttpResponse httpResponse;
            HttpRequest httpRequest = expectation.getHttpRequest();
            if (httpRequest != null) {
                this.httpRequest = new HttpRequestDTO(httpRequest, httpRequest.getNot());
            }
            if ((httpResponse = expectation.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            if ((httpResponseTemplate = expectation.getHttpResponseTemplate()) != null) {
                this.httpResponseTemplate = new HttpTemplateDTO(httpResponseTemplate);
            }
            if ((httpForward = expectation.getHttpForward()) != null) {
                this.httpForward = new HttpForwardDTO(httpForward);
            }
            if ((httpForwardTemplate = expectation.getHttpForwardTemplate()) != null) {
                this.httpForwardTemplate = new HttpTemplateDTO(httpForwardTemplate);
            }
            if ((httpError = expectation.getHttpError()) != null) {
                this.httpError = new HttpErrorDTO(httpError);
            }
            if ((httpClassCallback = expectation.getHttpClassCallback()) != null) {
                this.httpClassCallback = new HttpClassCallbackDTO(httpClassCallback);
            }
            if ((httpObjectCallback = expectation.getHttpObjectCallback()) != null) {
                this.httpObjectCallback = new HttpObjectCallbackDTO(httpObjectCallback);
            }
            if ((times = expectation.getTimes()) != null) {
                this.times = new TimesDTO(times);
            }
            if ((timeToLive = expectation.getTimeToLive()) != null) {
                this.timeToLive = new TimeToLiveDTO(timeToLive);
            }
        }
    }

    public ExpectationDTO() {
    }

    @Override
    public Expectation buildObject() {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        HttpTemplate httpResponseTemplate = null;
        HttpForward httpForward = null;
        HttpTemplate httpForwardTemplate = null;
        HttpError httpError = null;
        HttpClassCallback httpClassCallback = null;
        HttpObjectCallback httpObjectCallback = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        if (this.httpResponseTemplate != null) {
            httpResponseTemplate = this.httpResponseTemplate.buildObject();
        }
        if (this.httpForward != null) {
            httpForward = this.httpForward.buildObject();
        }
        if (this.httpForwardTemplate != null) {
            httpForwardTemplate = this.httpForwardTemplate.buildObject();
        }
        if (this.httpError != null) {
            httpError = this.httpError.buildObject();
        }
        if (this.httpClassCallback != null) {
            httpClassCallback = this.httpClassCallback.buildObject();
        }
        if (this.httpObjectCallback != null) {
            httpObjectCallback = this.httpObjectCallback.buildObject();
        }
        Times times = this.times != null ? this.times.buildObject() : Times.once();
        TimeToLive timeToLive = this.timeToLive != null ? this.timeToLive.buildObject() : TimeToLive.unlimited();
        return new Expectation(httpRequest, times, timeToLive).thenRespond(httpResponse).thenRespond(httpResponseTemplate).thenForward(httpForward).thenForward(httpForwardTemplate).thenError(httpError).thenCallback(httpClassCallback).thenCallback(httpObjectCallback);
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public ExpectationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public ExpectationDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpTemplateDTO getHttpResponseTemplate() {
        return this.httpResponseTemplate;
    }

    public ExpectationDTO setHttpResponseTemplate(HttpTemplateDTO httpResponseTemplate) {
        this.httpResponseTemplate = httpResponseTemplate;
        return this;
    }

    public HttpForwardDTO getHttpForward() {
        return this.httpForward;
    }

    public ExpectationDTO setHttpForward(HttpForwardDTO httpForward) {
        this.httpForward = httpForward;
        return this;
    }

    public HttpTemplateDTO getHttpForwardTemplate() {
        return this.httpForwardTemplate;
    }

    public ExpectationDTO setHttpForwardTemplate(HttpTemplateDTO httpForwardTemplate) {
        this.httpForwardTemplate = httpForwardTemplate;
        return this;
    }

    public HttpErrorDTO getHttpError() {
        return this.httpError;
    }

    public ExpectationDTO setHttpError(HttpErrorDTO httpError) {
        this.httpError = httpError;
        return this;
    }

    public HttpClassCallbackDTO getHttpClassCallback() {
        return this.httpClassCallback;
    }

    public ExpectationDTO setHttpClassCallback(HttpClassCallbackDTO httpClassCallback) {
        this.httpClassCallback = httpClassCallback;
        return this;
    }

    public HttpObjectCallbackDTO getHttpObjectCallback() {
        return this.httpObjectCallback;
    }

    public ExpectationDTO setHttpObjectCallback(HttpObjectCallbackDTO httpObjectCallback) {
        this.httpObjectCallback = httpObjectCallback;
        return this;
    }

    public TimesDTO getTimes() {
        return this.times;
    }

    public ExpectationDTO setTimes(TimesDTO times) {
        this.times = times;
        return this;
    }

    public TimeToLiveDTO getTimeToLive() {
        return this.timeToLive;
    }

    public ExpectationDTO setTimeToLive(TimeToLiveDTO timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }
}

