/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.unification;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.TimeUnit;
import org.mockserver.echo.unification.EchoServerUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortUnificationEchoServer {
    private NioEventLoopGroup eventLoopGroup;

    public PortUnificationEchoServer(final int port) {
        Logger logger = LoggerFactory.getLogger(PortUnificationEchoServer.class);
        final SettableFuture hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            @Override
            public void run() {
                PortUnificationEchoServer.this.eventLoopGroup = new NioEventLoopGroup();
                NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 100)).handler(new LoggingHandler("EchoServer Handler"))).childHandler(new EchoServerUnificationHandler()).bind(port).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            hasStarted.set("STARTED");
                        } else {
                            hasStarted.setException(future.cause());
                            PortUnificationEchoServer.this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }, "MockServer Port Unification EchoServer Thread").start();
        try {
            hasStarted.get();
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            logger.error("Exception while waiting for proxy to complete starting up", e);
        }
    }

    public void stop() {
        this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
    }
}

