/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.log.model.ExpectationLogEntry;
import org.mockserver.log.model.LogEntry;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class RequestResponseLogEntry
extends LogEntry
implements ExpectationLogEntry {
    private final HttpResponse httpResponse;

    public RequestResponseLogEntry(HttpRequest httpRequest, HttpResponse httpResponse) {
        super(httpRequest);
        this.httpResponse = httpResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    @JsonIgnore
    public Expectation getExpectation() {
        return new Expectation(this.getHttpRequest(), Times.once(), TimeToLive.unlimited()).thenRespond(this.httpResponse);
    }
}

