/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.model.NottableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XmlStringMatcher
extends BodyMatcher<NottableString> {
    private static Logger logger = LoggerFactory.getLogger(XmlStringMatcher.class);
    private NottableString matcher = NottableString.string("THIS SHOULD NEVER MATCH");
    private StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();

    public XmlStringMatcher(String matcher) {
        try {
            this.matcher = NottableString.string(this.normaliseXmlString(matcher));
        }
        catch (Exception e) {
            logger.error("Error while creating xml string matcher for [" + matcher + "]" + e.getMessage(), e);
        }
    }

    public XmlStringMatcher(NottableString matcher) {
        try {
            this.matcher = this.normaliseXmlNottableString(matcher);
        }
        catch (Exception e) {
            logger.error("Error while creating xml string matcher for [" + matcher + "]" + e.getMessage(), e);
        }
    }

    public String normaliseXmlString(final String input) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        return this.stringToXmlDocumentParser.normaliseXmlString(input, new StringToXmlDocumentParser.ErrorLogger(){

            @Override
            public void logError(String matched, Exception exception) {
                logger.debug("SAXParseException while parsing [" + input + "]", exception);
            }
        });
    }

    public NottableString normaliseXmlNottableString(NottableString input) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return NottableString.string(this.normaliseXmlString(input.getValue()), input.getNot());
    }

    @Override
    public boolean matches(String matched) {
        return this.matches(NottableString.string(matched));
    }

    @Override
    public boolean matches(NottableString matched) {
        boolean result = false;
        try {
            if (ExactStringMatcher.matches(this.matcher.getValue(), this.normaliseXmlString(matched.getValue()), false)) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.trace("Error while matching xml string [" + this.matcher + "] against xml string [" + matched + "] assuming no match - " + e.getMessage());
        }
        if (!result) {
            logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return this.matcher.isNot() != this.reverseResultIfNot(result);
    }
}

