/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;

public class NettyResponseWriter
extends ResponseWriter {
    private CORSHeaders addCORSHeaders = new CORSHeaders();
    private final ChannelHandlerContext ctx;

    public NettyResponseWriter(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(responseStatus.code()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; charset=utf-8"));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.writeResponse(request, response);
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.addConnectionHeader(request, response);
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel;
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getCloseSocket() != null) {
            closeChannel = connectionOptions.getCloseSocket();
        } else {
            boolean bl = closeChannel = request.isKeepAlive() == null || request.isKeepAlive() == false;
        }
        if (closeChannel) {
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush(response);
        }
    }
}

