/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.mockserver.model.StringBody;

public class HttpRequest
extends Not {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters queryStringParameters = new Parameters(new Parameter[0]);
    private Body body = null;
    private Headers headers = new Headers(new Header[0]);
    private Cookies cookies = new Cookies(new Cookie[0]);
    private Boolean keepAlive = null;
    private Boolean secure = null;

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public static HttpRequest request(String path) {
        return new HttpRequest().withPath(path);
    }

    public Boolean isKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequest withKeepAlive(Boolean isKeepAlive) {
        this.keepAlive = isKeepAlive;
        return this;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public HttpRequest withSecure(Boolean isSsl) {
        this.secure = isSsl;
        return this;
    }

    public HttpRequest withMethod(String method) {
        return this.withMethod(NottableString.string(method));
    }

    public HttpRequest withMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getMethod() {
        return this.method;
    }

    public String getMethod(String defaultValue) {
        if (Strings.isNullOrEmpty(this.method.getValue())) {
            return defaultValue;
        }
        return this.method.getValue();
    }

    public HttpRequest withPath(String path) {
        this.withPath(NottableString.string(path));
        return this;
    }

    public HttpRequest withPath(NottableString path) {
        this.path = path;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public boolean matches(String method, String path) {
        return this.method.getValue().equals(method) && this.path.getValue().equals(path);
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequest withQueryStringParameters(Parameters parameters) {
        this.queryStringParameters = parameters;
        return this;
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameters.withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        this.queryStringParameters.withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.queryStringParameters.withEntries(parameters);
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        this.queryStringParameters.withEntry(parameter);
        return this;
    }

    public HttpRequest withQueryStringParameter(String name, String ... values) {
        this.queryStringParameters.withEntry(name, values);
        return this;
    }

    public HttpRequest withQueryStringParameter(NottableString name, NottableString ... values) {
        this.queryStringParameters.withEntry(name, values);
        return this;
    }

    public List<Parameter> getQueryStringParameterList() {
        return this.queryStringParameters.getEntries();
    }

    public boolean hasQueryStringParameter(String name, String value) {
        return this.queryStringParameters.containsEntry(name, value);
    }

    public boolean hasQueryStringParameter(NottableString name, NottableString value) {
        return this.queryStringParameters.containsEntry(name, value);
    }

    public String getFirstQueryStringParameter(String name) {
        return this.queryStringParameters.getFirstValue(name);
    }

    public HttpRequest withBody(String body) {
        this.body = new StringBody(body);
        return this;
    }

    public HttpRequest withBody(String body, Charset charset) {
        if (body != null) {
            this.body = new StringBody(body, charset);
        }
        return this;
    }

    public HttpRequest withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpRequest withBody(Body body) {
        this.body = body;
        return this;
    }

    public Body getBody() {
        return this.body;
    }

    @JsonIgnore
    public byte[] getBodyAsRawBytes() {
        return this.body != null ? this.body.getRawBytes() : new byte[]{};
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpRequest withHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequest withHeaders(List<Header> headers) {
        this.headers.withEntries(headers);
        return this;
    }

    public HttpRequest withHeaders(Header ... headers) {
        this.headers.withEntries(headers);
        return this;
    }

    public HttpRequest withHeader(Header header) {
        this.headers.withEntry(header);
        return this;
    }

    public HttpRequest withHeader(String name, String ... values) {
        this.headers.withEntry(name, values);
        return this;
    }

    public HttpRequest withHeader(NottableString name, NottableString ... values) {
        this.headers.withEntry(name, values);
        return this;
    }

    public HttpRequest replaceHeader(Header header) {
        this.headers.replaceEntry(header);
        return this;
    }

    public List<Header> getHeaderList() {
        return this.headers.getEntries();
    }

    public List<String> getHeader(String name) {
        return this.headers.getValues(name);
    }

    public String getFirstHeader(String name) {
        return this.headers.getFirstValue(name);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsEntry(name);
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpRequest withCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public HttpRequest withCookies(List<Cookie> cookies) {
        this.cookies.withEntries(cookies);
        return this;
    }

    public HttpRequest withCookies(Cookie ... cookies) {
        this.cookies.withEntries(cookies);
        return this;
    }

    public HttpRequest withCookie(Cookie cookie) {
        this.cookies.withEntry(cookie);
        return this;
    }

    public HttpRequest withCookie(String name, String value) {
        this.cookies.withEntry(name, value);
        return this;
    }

    public HttpRequest withCookie(NottableString name, NottableString value) {
        this.cookies.withEntry(name, value);
        return this;
    }

    public List<Cookie> getCookieList() {
        return this.cookies.getEntries();
    }

    public HttpRequest clone() {
        return HttpRequest.not(HttpRequest.request(), this.not).withMethod(this.method).withPath(this.path).withQueryStringParameters(this.getQueryStringParameters().clone()).withBody(this.body).withHeaders(this.getHeaders().clone()).withCookies(this.getCookies().clone()).withKeepAlive(this.keepAlive).withSecure(this.secure);
    }
}

