/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.http.HttpProxyUnificationHandler;
import org.slf4j.LoggerFactory;

public class HttpProxy
extends Proxy<HttpProxy> {
    private ProxySelector previousProxySelector;

    public HttpProxy(Integer ... requestedPortBindings) {
        if (requestedPortBindings == null || requestedPortBindings.length == 0) {
            throw new IllegalArgumentException("You must specify at least one port");
        }
        this.serverBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, 1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, true).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).childHandler(new HttpProxyUnificationHandler()).childAttr(HTTP_PROXY, this).childAttr(HTTP_CONNECT_SOCKET, new InetSocketAddress(requestedPortBindings[0])).childAttr(STATE_HANDLER, new HttpStateHandler());
        this.bindToPorts(Arrays.asList(requestedPortBindings));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                HttpProxy.this.bossGroup.shutdownGracefully();
                HttpProxy.this.workerGroup.shutdownGracefully();
                try {
                    HttpProxy.this.bossGroup.terminationFuture().sync();
                    HttpProxy.this.workerGroup.terminationFuture().sync();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }));
    }

    private static ProxySelector createProxySelector(final String host, final int port) {
        return new ProxySelector(){

            @Override
            public List<java.net.Proxy> select(URI uri) {
                return Collections.singletonList(new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                LoggerFactory.getLogger(HttpProxy.class).error("Connection could not be established to proxy at socket [" + sa + "]", ioe);
            }
        };
    }

    @Override
    protected void started(Integer port) {
        ConfigurationProperties.proxyPort(port);
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", port.toString());
    }

    @Override
    protected void stopped() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
    }
}

