/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.report;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.core.exceptions.ExceptionProvider;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.SimpleExceptionProvider;
import com.github.fge.jsonschema.core.util.AsJson;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ProcessingMessage
implements AsJson {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final Map<String, JsonNode> map = Maps.newLinkedHashMap();
    private final List<Object> args = Lists.newArrayList();
    private ExceptionProvider exceptionProvider = SimpleExceptionProvider.getInstance();
    private LogLevel level;

    public ProcessingMessage() {
        this.setLogLevel(LogLevel.INFO);
    }

    public String getMessage() {
        return this.map.containsKey("message") ? this.map.get("message").textValue() : "(no message)";
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    public ProcessingMessage setMessage(String message) {
        this.args.clear();
        return this.put("message", message);
    }

    public ProcessingMessage setLogLevel(LogLevel level) {
        BUNDLE.checkNotNull(level, "processing.nullLevel");
        this.level = level;
        return this.put("level", level);
    }

    public ProcessingMessage setExceptionProvider(ExceptionProvider exceptionProvider) {
        BUNDLE.checkNotNull(exceptionProvider, "processing.nullExceptionProvider");
        this.exceptionProvider = exceptionProvider;
        return this;
    }

    public ProcessingMessage put(String key, JsonNode value) {
        if (key == null) {
            return this;
        }
        if (value == null) {
            return this.putNull(key);
        }
        this.map.put(key, (JsonNode)value.deepCopy());
        return this;
    }

    public ProcessingMessage putArgument(String key, JsonNode value) {
        this.addArgument(key, value);
        return this.put(key, value);
    }

    public ProcessingMessage put(String key, AsJson asJson) {
        return this.put(key, asJson.asJson());
    }

    public ProcessingMessage putArgument(String key, AsJson asJson) {
        this.addArgument(key, asJson.asJson());
        return this.put(key, asJson);
    }

    public ProcessingMessage put(String key, String value) {
        return value == null ? this.putNull(key) : this.put(key, FACTORY.textNode(value));
    }

    public ProcessingMessage put(String key, int value) {
        return this.put(key, FACTORY.numberNode(value));
    }

    public ProcessingMessage putArgument(String key, int value) {
        this.addArgument(key, value);
        return this.put(key, value);
    }

    public <T> ProcessingMessage put(String key, T value) {
        return value == null ? this.putNull(key) : this.put(key, FACTORY.textNode(value.toString()));
    }

    public <T> ProcessingMessage putArgument(String key, T value) {
        this.addArgument(key, value);
        return this.put(key, value);
    }

    public <T> ProcessingMessage put(String key, Iterable<T> values) {
        if (values == null) {
            return this.putNull(key);
        }
        ArrayNode node = FACTORY.arrayNode();
        for (T value : values) {
            node.add(value == null ? FACTORY.nullNode() : FACTORY.textNode(value.toString()));
        }
        return this.put(key, node);
    }

    public <T> ProcessingMessage putArgument(String key, Iterable<T> values) {
        this.addArgument(key, values);
        return this.put(key, values);
    }

    private void addArgument(String key, Object value) {
        if (key != null) {
            this.args.add(value);
        }
        if (!this.map.containsKey("message")) {
            return;
        }
        String fmt = this.map.get("message").textValue();
        try {
            String formatted = new Formatter().format(fmt, this.args.toArray()).toString();
            this.map.put("message", FACTORY.textNode(formatted));
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
    }

    private ProcessingMessage putNull(String key) {
        if (key == null) {
            return this;
        }
        this.map.put(key, FACTORY.nullNode());
        return this;
    }

    @Override
    public JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.putAll(this.map);
        return ret;
    }

    public ProcessingException asException() {
        return this.exceptionProvider.doException(this);
    }

    public String toString() {
        LinkedHashMap<String, JsonNode> tmp = Maps.newLinkedHashMap(this.map);
        JsonNode node = (JsonNode)tmp.remove("message");
        String message = node == null ? "(no message)" : node.textValue();
        StringBuilder sb = new StringBuilder().append((Object)this.level).append(": ");
        sb.append(message);
        for (Map.Entry entry : tmp.entrySet()) {
            sb.append("\n    ").append((String)entry.getKey()).append(": ").append(entry.getValue());
        }
        return sb.append('\n').toString();
    }
}

