/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MacroOverflowException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.Renderable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

public class VelocimacroProxy
extends Directive {
    private String macroName;
    private List<Macro.MacroArg> macroArgs = null;
    private String[] literalArgArray = null;
    private SimpleNode nodeTree = null;
    private int numMacroArgs = 0;
    private boolean strictArguments;
    private int maxCallDepth;
    private String bodyReference;

    @Override
    public String getName() {
        return this.macroName;
    }

    @Override
    public int getType() {
        return 2;
    }

    public void setName(String string) {
        this.macroName = string;
    }

    public void setMacroArgs(List<Macro.MacroArg> list) {
        this.macroArgs = list;
        this.literalArgArray = new String[this.macroArgs.size()];
        for (int i = 0; i < this.macroArgs.size(); ++i) {
            this.literalArgArray[i] = ".literal.$" + this.macroArgs.get(i);
        }
        this.numMacroArgs = this.macroArgs.size() - 1;
    }

    public List<Macro.MacroArg> getMacroArgs() {
        return this.macroArgs;
    }

    public void setNodeTree(SimpleNode simpleNode) {
        this.nodeTree = simpleNode;
    }

    public int getNumArgs() {
        return this.numMacroArgs;
    }

    public void init(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
        this.log = runtimeServices.getLog("macro");
        this.strictArguments = this.rsvc.getBoolean("velocimacro.arguments.strict", false);
        this.maxCallDepth = this.rsvc.getInt("velocimacro.max.depth");
        this.bodyReference = this.rsvc.getString("velocimacro.body.reference", "bodyContent");
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        return this.render(internalContextAdapter, writer, node, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node, Renderable renderable) throws IOException {
        boolean bl;
        int n = node.jjtGetNumChildren();
        Object object = null;
        if (renderable != null) {
            object = internalContextAdapter.get(this.bodyReference);
            internalContextAdapter.put(this.bodyReference, renderable);
            --n;
        }
        this.checkArgumentCount(node, n);
        this.checkDepth(internalContextAdapter);
        Object[] objectArray = this.handleArgValues(internalContextAdapter, node, n);
        try {
            internalContextAdapter.pushCurrentMacroName(this.macroName);
            this.nodeTree.render(internalContextAdapter, writer);
            internalContextAdapter.popCurrentMacroName();
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            try {
                throw runtimeException;
                catch (Exception exception) {
                    String string = "VelocimacroProxy.render() : exception VM = #" + this.macroName + "()";
                    this.log.error(string, exception);
                    throw new VelocityException(string, exception);
                }
            }
            catch (Throwable throwable) {
                Object object2 = internalContextAdapter.get(this.bodyReference);
                if (object2 == renderable) {
                    if (object != null) {
                        internalContextAdapter.put(this.bodyReference, object);
                    } else {
                        internalContextAdapter.remove(this.bodyReference);
                    }
                }
                int n2 = 1;
                while (true) {
                    if (n2 >= this.macroArgs.size()) {
                        throw throwable;
                    }
                    Macro.MacroArg macroArg = this.macroArgs.get(n2);
                    object2 = internalContextAdapter.get(macroArg.name);
                    if (object2 == objectArray[(n2 - 1) * 2 + 1]) {
                        Object object3 = objectArray[(n2 - 1) * 2];
                        if (object3 != null) {
                            internalContextAdapter.put(macroArg.name, object3);
                        } else {
                            internalContextAdapter.remove(macroArg.name);
                        }
                    }
                    ++n2;
                }
            }
        }
        Object object4 = internalContextAdapter.get(this.bodyReference);
        if (object4 == renderable) {
            if (object != null) {
                internalContextAdapter.put(this.bodyReference, object);
            } else {
                internalContextAdapter.remove(this.bodyReference);
            }
        }
        int n3 = 1;
        while (n3 < this.macroArgs.size()) {
            Macro.MacroArg macroArg = this.macroArgs.get(n3);
            object4 = internalContextAdapter.get(macroArg.name);
            if (object4 == objectArray[(n3 - 1) * 2 + 1]) {
                Object object5 = objectArray[(n3 - 1) * 2];
                if (object5 != null) {
                    internalContextAdapter.put(macroArg.name, object5);
                } else {
                    internalContextAdapter.remove(macroArg.name);
                }
            }
            ++n3;
        }
        return bl;
    }

    protected void checkArgumentCount(Node node, int n) {
        if (n > this.macroArgs.size() - 1) {
            if (this.strictArguments) {
                throw new VelocityException("Provided " + n + " arguments but macro #" + this.macroArgs.get((int)0).name + " accepts at most " + (this.macroArgs.size() - 1) + " at " + StringUtils.formatFileString(node));
            }
            this.log.debug("VM #{}: too many arguments to macro. Wanted {} got {}", this.macroArgs.get((int)0).name, this.macroArgs.size() - 1, n);
        }
    }

    protected void checkDepth(InternalContextAdapter internalContextAdapter) {
        if (this.maxCallDepth > 0 && this.maxCallDepth == internalContextAdapter.getCurrentMacroCallDepth()) {
            String[] stringArray = internalContextAdapter.getMacroNameStack();
            StringBuilder stringBuilder = new StringBuilder(100).append("Max calling depth of ").append(this.maxCallDepth).append(" was exceeded in macro '").append(this.macroName).append("' with Call Stack:");
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuilder.append("->");
                }
                stringBuilder.append(stringArray[i]);
            }
            stringBuilder.append(" at ").append(StringUtils.formatFileString(this));
            this.log.error(stringBuilder.toString());
            while (internalContextAdapter.getCurrentMacroCallDepth() > 0) {
                internalContextAdapter.popCurrentMacroName();
            }
            throw new MacroOverflowException(stringBuilder.toString());
        }
    }

    protected Object[] handleArgValues(InternalContextAdapter internalContextAdapter, Node node, int n) {
        Object[] objectArray = new Object[this.macroArgs.size() * 2];
        for (int i = 1; i < this.macroArgs.size(); ++i) {
            Macro.MacroArg macroArg = this.macroArgs.get(i);
            objectArray[(i - 1) * 2] = internalContextAdapter.get(macroArg.name);
            Object object = null;
            if (i - 1 < n) {
                object = node.jjtGetChild(i - 1).value(internalContextAdapter);
            } else if (macroArg.defaultVal != null) {
                object = macroArg.defaultVal.value(internalContextAdapter);
            } else {
                if (this.strictArguments) {
                    int n2 = -1;
                    for (Macro.MacroArg macroArg2 : this.macroArgs) {
                        if (macroArg2.defaultVal != null) continue;
                        ++n2;
                    }
                    throw new VelocityException("Need at least " + n2 + " argument for macro #" + this.macroArgs.get((int)0).name + " but only " + n + " where provided at " + StringUtils.formatFileString(node));
                }
                this.log.debug("VM #{}: too few arguments to macro. Wanted {} got {}", this.macroArgs.get((int)0).name, this.macroArgs.size() - 1, n);
                break;
            }
            internalContextAdapter.put(macroArg.name, object);
            objectArray[(i - 1) * 2 + 1] = object;
        }
        return objectArray;
    }
}

