/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;

public class XmlBody
extends BodyWithContentType<String> {
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.create("application", "xml");
    private final String xml;
    private final byte[] rawBinaryData;

    public XmlBody(String xml) {
        this(xml, DEFAULT_CONTENT_TYPE);
    }

    public XmlBody(String xml, Charset charset) {
        this(xml, charset != null ? MediaType.create("application", "xml").withCharset(charset) : null);
    }

    public XmlBody(String xml, MediaType contentType) {
        super(Body.Type.XML, contentType);
        this.xml = xml;
        this.rawBinaryData = xml != null ? xml.getBytes(this.determineCharacterSet(contentType, ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET)) : new byte[0];
    }

    public static XmlBody xml(String xml) {
        return new XmlBody(xml);
    }

    public static XmlBody xml(String xml, Charset charset) {
        return new XmlBody(xml, charset);
    }

    public static XmlBody xml(String xml, MediaType contentType) {
        return new XmlBody(xml, contentType);
    }

    public String getValue() {
        return this.xml;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBinaryData;
    }

    @Override
    public String toString() {
        return this.xml;
    }
}

