/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandler;
import org.slf4j.Logger;

public class DownstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private final Logger logger;
    private volatile Channel upstreamChannel;

    public DownstreamProxyRelayHandler(Channel upstreamChannel, Logger logger) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.logger = logger;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void channelRead0(final ChannelHandlerContext ctx, final FullHttpResponse response) {
        this.upstreamChannel.writeAndFlush(response).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    if (DownstreamProxyRelayHandler.this.isNotSocketClosedException(future.cause())) {
                        DownstreamProxyRelayHandler.this.logger.error("Exception while returning writing " + response, future.cause());
                    }
                    future.channel().close();
                }
            }
        });
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandler.closeOnFlush(this.upstreamChannel);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by downstream relay handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

