/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import java.net.InetSocketAddress;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.socket.NettySslContextFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    @VisibleForTesting
    public static Logger logger = LoggerFactory.getLogger(RelayConnectHandler.class);
    private final String host;
    private final int port;

    public RelayConnectHandler(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void channelRead0(final ChannelHandlerContext serverCtx, final T request) throws Exception {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(serverCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler(new ChannelInboundHandlerAdapter(){

            @Override
            public void channelActive(final ChannelHandlerContext clientCtx) throws Exception {
                serverCtx.channel().writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        RelayConnectHandler.this.removeCodecSupport(serverCtx);
                        serverCtx.channel().attr(Proxy.PROXYING).set(Boolean.TRUE);
                        ChannelPipeline downstreamPipeline = clientCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledDownstream(serverCtx.channel())) {
                            downstreamPipeline.addLast(NettySslContextFactory.nettySslContextFactory().createClientSslContext().newHandler(clientCtx.alloc(), RelayConnectHandler.this.host, RelayConnectHandler.this.port));
                        }
                        if (logger.isTraceEnabled()) {
                            downstreamPipeline.addLast(new LoggingHandler("downstream                -->"));
                        }
                        downstreamPipeline.addLast(new HttpClientCodec());
                        downstreamPipeline.addLast(new HttpContentDecompressor());
                        downstreamPipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                        downstreamPipeline.addLast(new DownstreamProxyRelayHandler(serverCtx.channel(), logger));
                        ChannelPipeline upstreamPipeline = serverCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledUpstream(serverCtx.channel())) {
                            upstreamPipeline.addLast(NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(serverCtx.alloc()));
                        }
                        if (logger.isTraceEnabled()) {
                            upstreamPipeline.addLast(new LoggingHandler("upstream <-- "));
                        }
                        upstreamPipeline.addLast(new HttpServerCodec(8192, 8192, 8192));
                        upstreamPipeline.addLast(new HttpContentDecompressor());
                        upstreamPipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                        upstreamPipeline.addLast(new UpstreamProxyRelayHandler(serverCtx.channel(), clientCtx.channel(), logger));
                    }
                });
            }
        });
        final InetSocketAddress remoteSocket = this.getDownstreamSocket(serverCtx.channel());
        bootstrap.connect(remoteSocket).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RelayConnectHandler.this.failure("Connection failed to " + remoteSocket, future.cause(), serverCtx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
    }

    private InetSocketAddress getDownstreamSocket(Channel channel) {
        if (channel.attr(ActionHandler.REMOTE_SOCKET).get() != null) {
            return channel.attr(ActionHandler.REMOTE_SOCKET).get();
        }
        if (channel.attr(Proxy.HTTP_CONNECT_SOCKET).get() != null) {
            return channel.attr(Proxy.HTTP_CONNECT_SOCKET).get();
        }
        throw new IllegalStateException("Trying to connect to remote socket but no remote socket has been set");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            logger.warn(message, cause);
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

