/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.callback;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.mockserver.callback.WebSocketRequestCallback;
import org.mockserver.callback.WebSocketResponseCallback;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.metrics.Metrics;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.mockserver.websocket.WebSocketException;
import org.slf4j.event.Level;

public class WebSocketClientRegistry {
    public static final String WEB_SOCKET_CORRELATION_ID_HEADER_NAME = "WebSocketCorrelationId";
    private final MockServerLogger mockServerLogger;
    private final WebSocketMessageSerializer webSocketMessageSerializer;
    private final CircularHashMap<String, ChannelHandlerContext> clientRegistry = new CircularHashMap(ConfigurationProperties.maxWebSocketExpectations());
    private final CircularHashMap<String, WebSocketResponseCallback> responseCallbackRegistry = new CircularHashMap(ConfigurationProperties.maxWebSocketExpectations());
    private final CircularHashMap<String, WebSocketRequestCallback> forwardCallbackRegistry = new CircularHashMap(ConfigurationProperties.maxWebSocketExpectations());

    public WebSocketClientRegistry(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer(mockServerLogger);
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block10: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (deserializedMessage instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)deserializedMessage;
                    String firstHeader = httpResponse.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketResponseCallback webSocketResponseCallback = (WebSocketResponseCallback)this.responseCallbackRegistry.get(firstHeader);
                    if (webSocketResponseCallback != null) {
                        webSocketResponseCallback.handle(httpResponse);
                    }
                    break block10;
                }
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                    String firstHeader = httpRequest.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketRequestCallback webSocketRequestCallback = (WebSocketRequestCallback)this.forwardCallbackRegistry.get(firstHeader);
                    if (webSocketRequestCallback != null) {
                        webSocketRequestCallback.handle(httpRequest);
                    }
                    break block10;
                }
                if (deserializedMessage instanceof WebSocketErrorDTO) {
                    WebSocketErrorDTO webSocketErrorDTO = (WebSocketErrorDTO)deserializedMessage;
                    if (this.forwardCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        ((WebSocketRequestCallback)this.forwardCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId())).handleError(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    } else if (this.responseCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        ((WebSocketResponseCallback)this.responseCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId())).handle(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    }
                    break block10;
                }
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message" + textWebSocketFrame.text(), e);
            }
        }
    }

    void registerClient(String clientId, ChannelHandlerContext ctx) {
        try {
            ctx.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketClientIdDTO().setClientId(clientId))));
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket registration client id message to client " + clientId, e);
        }
        this.clientRegistry.put(clientId, ctx);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_CLIENT_COUNT, this.clientRegistry.size());
    }

    void unregisterClient(String clientId) {
        this.clientRegistry.remove(clientId);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_CLIENT_COUNT, this.clientRegistry.size());
    }

    public void registerResponseCallbackHandler(String webSocketCorrelationId, WebSocketResponseCallback expectationResponseCallback) {
        this.responseCallbackRegistry.put(webSocketCorrelationId, expectationResponseCallback);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT, this.responseCallbackRegistry.size());
    }

    public void unregisterResponseCallbackHandler(String webSocketCorrelationId) {
        this.responseCallbackRegistry.remove(webSocketCorrelationId);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT, this.responseCallbackRegistry.size());
    }

    public void registerForwardCallbackHandler(String webSocketCorrelationId, WebSocketRequestCallback expectationForwardCallback) {
        this.forwardCallbackRegistry.put(webSocketCorrelationId, expectationForwardCallback);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT, this.forwardCallbackRegistry.size());
    }

    public void unregisterForwardCallbackHandler(String webSocketCorrelationId) {
        this.forwardCallbackRegistry.remove(webSocketCorrelationId);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT, this.forwardCallbackRegistry.size());
    }

    public boolean sendClientMessage(String clientId, HttpRequest httpRequest) {
        try {
            if (this.clientRegistry.containsKey(clientId)) {
                ((ChannelHandlerContext)this.clientRegistry.get(clientId)).channel().writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequest)));
                return true;
            }
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setHttpRequest(httpRequest).setMessageFormat("Client " + clientId + " not found for request {} client registry only contains {}").setArguments(httpRequest, this.clientRegistry));
            return false;
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket message " + httpRequest + " to client " + clientId, e);
        }
    }
}

