/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BoundedConcurrentLinkedQueue<E>
extends ConcurrentLinkedQueue<E> {
    static final long serialVersionUID = -8190199206751953870L;
    private final int maxSize;

    public BoundedConcurrentLinkedQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(E element) {
        if (this.maxSize > 0) {
            if (this.size() >= this.maxSize) {
                super.poll();
            }
            return super.add(element);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.maxSize > 0) {
            boolean result = false;
            for (E element : collection) {
                if (!this.add(element)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean offer(E element) {
        if (this.maxSize > 0) {
            if (this.size() >= this.maxSize) {
                super.poll();
            }
            return super.offer(element);
        }
        return false;
    }
}

