/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;

public class CaseInsensitiveRegexHashMap
extends LinkedHashMap<NottableString, NottableString>
implements Map<NottableString, NottableString> {
    private final RegexStringMatcher regexStringMatcher;
    private final MockServerLogger mockServerLogger;

    public CaseInsensitiveRegexHashMap(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger);
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexHashMap hashMap(String[] ... keyAndValues) {
        CaseInsensitiveRegexHashMap hashMap = new CaseInsensitiveRegexHashMap(new MockServerLogger());
        for (String[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            hashMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return hashMap;
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexHashMap hashMap(NottableString[] ... keyAndValues) {
        CaseInsensitiveRegexHashMap hashMap = new CaseInsensitiveRegexHashMap(new MockServerLogger());
        for (NottableString[] keyAndValue : keyAndValues) {
            if (keyAndValue.length < 2) continue;
            hashMap.put(keyAndValue[0], keyAndValue[1]);
        }
        return hashMap;
    }

    public boolean containsAll(CaseInsensitiveRegexHashMap subSet) {
        if (this.size() == 0 && subSet.allKeysNotted()) {
            return true;
        }
        for (Map.Entry entry : subSet.entrySet()) {
            if ((((NottableString)entry.getKey()).isNot() || ((NottableString)entry.getValue()).isNot()) && this.containsKeyValue(((NottableString)entry.getKey()).getValue(), ((NottableString)entry.getValue()).getValue())) {
                Map.Entry<NottableString, NottableString> matchingEntry = this.retrieveEntry((NottableString)entry.getKey(), (NottableString)entry.getValue());
                if (matchingEntry != null) {
                    return ((NottableString)entry.getKey()).isNot() == matchingEntry.getKey().isNot() && ((NottableString)entry.getValue()).isNot() == matchingEntry.getValue().isNot();
                }
                return false;
            }
            if (this.containsKeyValue((NottableString)entry.getKey(), (NottableString)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean allKeysNotted() {
        for (NottableString key : this.keySet()) {
            if (key.isNot()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        return this.containsKeyValue(NottableString.string(key), NottableString.string(value));
    }

    public synchronized boolean containsKeyValue(NottableString key, NottableString value) {
        boolean result = false;
        for (Map.Entry matcherEntry : this.entrySet()) {
            if (!this.regexStringMatcher.matches(value, (NottableString)matcherEntry.getValue(), true) || !this.regexStringMatcher.matches(key, (NottableString)matcherEntry.getKey(), true)) continue;
            result = true;
            break;
        }
        return result;
    }

    private synchronized Map.Entry<NottableString, NottableString> retrieveEntry(NottableString key, NottableString value) {
        for (Map.Entry<NottableString, NottableString> entry : this.entrySet()) {
            if (!this.regexStringMatcher.matches(value, (NottableString)entry.getValue(), true) || !this.regexStringMatcher.matches(key, (NottableString)entry.getKey(), true)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        boolean result = false;
        if (key instanceof NottableString) {
            for (NottableString keyToCompare : this.keySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, keyToCompare, true)) continue;
                result = true;
                break;
            }
        } else if (key instanceof String) {
            result = this.containsKey(NottableString.string((String)key));
        }
        return result;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        boolean result = false;
        if (value instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)value, (NottableString)entry.getValue(), true)) continue;
                return true;
            }
        } else if (value instanceof String) {
            result = this.containsValue(NottableString.string((String)value));
        }
        return result;
    }

    @Override
    public synchronized NottableString get(Object key) {
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                return (NottableString)super.get(entry.getKey());
            }
        } else if (key instanceof String) {
            return this.get(NottableString.string((String)key));
        }
        return null;
    }

    @Override
    public synchronized NottableString put(String key, String value) {
        return super.put(NottableString.string(key), NottableString.string(value));
    }

    @Override
    public synchronized NottableString put(NottableString key, NottableString value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return super.put(key, value);
    }

    @Override
    public synchronized NottableString remove(Object key) {
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                return (NottableString)super.remove(entry.getKey());
            }
        } else if (key instanceof String) {
            return this.remove(NottableString.string((String)key));
        }
        return null;
    }
}

