/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.UUID;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class WebSocketServerHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET = AttributeKey.valueOf("CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI = "/_mockserver_callback_websocket";
    private final MockServerLogger mockServerLogger;
    private final List<String> registeredClients;
    private final List<Channel> websocketChannels;
    private final List<TextWebSocketFrame> textWebSocketFrames;
    private WebSocketServerHandshaker handshaker;

    WebSocketServerHandler(MockServerLogger mockServerLogger, List<String> registeredClients, List<Channel> websocketChannels, List<TextWebSocketFrame> textWebSocketFrames) {
        this.mockServerLogger = mockServerLogger;
        this.registeredClients = registeredClients;
        this.websocketChannels = websocketChannels;
        this.textWebSocketFrames = textWebSocketFrames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).set(true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get() != null && ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get().booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory("ws://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI, null, true, Integer.MAX_VALUE).newHandshaker(httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
        } else {
            String clientId = UUID.randomUUID().toString();
            this.handshaker.handshake(ctx.channel(), httpRequest, new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), ctx.channel().newPromise()).addListener(future -> {
                ctx.pipeline().remove(MockServerServerCodec.class);
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Registering client " + clientId));
                this.registeredClients.add(clientId);
                this.websocketChannels.add(future.channel());
                future.channel().closeFuture().addListener(future1 -> {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Unregistering callback for client " + clientId));
                    this.registeredClients.remove(clientId);
                    this.websocketChannels.remove(future.channel());
                });
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
        } else if (frame instanceof TextWebSocketFrame) {
            this.textWebSocketFrames.add((TextWebSocketFrame)frame);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write(new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(frame.getClass().getName() + " frame types not supported");
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("web socket server caught exception").setThrowable(cause));
        ctx.close();
    }
}

