/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class ContentTypeMapper {
    public static final Charset DEFAULT_HTTP_CHARACTER_SET = CharsetUtil.ISO_8859_1;
    private static final Set<String> UTF_8_CONTENT_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("application/atom+xml")).add("application/ecmascript")).add("application/javascript")).add("application/json")).add("application/jsonml+json")).add("application/lost+xml")).add("application/wsdl+xml")).add("application/xaml+xml")).add("application/xhtml+xml")).add("application/xml")).add("application/xml-dtd")).add("application/xop+xml")).add("application/xslt+xml")).add("application/xspf+xml")).add("application/x-www-form-urlencoded")).add("image/svg+xml")).add("text/css")).add("text/csv")).add("text/html")).add("text/plain")).add("text/richtext")).add("text/sgml")).add("text/tab-separated-values")).add("text/x-fortran")).add("text/x-java-source")).build();
    private final MockServerLogger mockServerLogger;

    public static boolean isBinary(String contentTypeHeader) {
        boolean binary = false;
        if (StringUtils.isNotBlank(contentTypeHeader)) {
            boolean utf8Body;
            String contentType = contentTypeHeader.toLowerCase();
            boolean bl = utf8Body = contentType.contains("utf-8") || contentType.contains("utf8") || contentType.contains("text") || contentType.contains("javascript") || contentType.contains("json") || contentType.contains("ecmascript") || contentType.contains("css") || contentType.contains("csv") || contentType.contains("html") || contentType.contains("xhtml") || contentType.contains("form") || contentType.contains("urlencoded") || contentType.contains("xml");
            if (!utf8Body) {
                binary = contentType.contains("ogg") || contentType.contains("audio") || contentType.contains("video") || contentType.contains("image") || contentType.contains("pdf") || contentType.contains("postscript") || contentType.contains("font") || contentType.contains("woff") || contentType.contains("model") || contentType.contains("zip") || contentType.contains("gzip") || contentType.contains("nacl") || contentType.contains("pnacl") || contentType.contains("vnd") || contentType.contains("application");
            }
        }
        return binary;
    }

    public ContentTypeMapper(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public Charset getCharsetFromContentTypeHeader(String contentType) {
        Charset charset = DEFAULT_HTTP_CHARACTER_SET;
        if (contentType != null) {
            String charsetName = StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + '=').replaceAll("\"", "");
            if (StringUtils.isNotBlank(charsetName)) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (UnsupportedCharsetException uce) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setMessageFormat("Unsupported character set {} in Content-Type header: {}.").setArguments(StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + 61), contentType));
                }
                catch (IllegalCharsetNameException icne) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setMessageFormat("Illegal character set {} in Content-Type header: {}.").setArguments(StringUtils.substringAfterLast(contentType, HttpHeaderValues.CHARSET.toString() + 61), contentType));
                }
            } else if (UTF_8_CONTENT_TYPES.contains(contentType)) {
                charset = CharsetUtil.UTF_8;
            }
        }
        return charset;
    }
}

