/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeysToMultiValues;
import org.slf4j.event.Level;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexMultiMap multiMap;

    public MultiValueMapMatcher(MockServerLogger mockServerLogger, KeysToMultiValues keysToMultiValues) {
        this.mockServerLogger = mockServerLogger;
        this.multiMap = keysToMultiValues != null ? keysToMultiValues.toCaseInsensitiveRegexMultiMap(mockServerLogger) : null;
    }

    @Override
    public boolean matches(HttpRequest context, KeysToMultiValues values) {
        boolean result;
        if (this.multiMap == null || this.multiMap.isEmpty()) {
            result = true;
        } else if (values == null || values.isEmpty()) {
            result = this.multiMap.allKeysNotted();
        } else if (values.toCaseInsensitiveRegexMultiMap(this.mockServerLogger).containsAll(this.multiMap)) {
            result = true;
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("MultiMap {} is not a subset of {}").setArguments(this.multiMap, values));
            result = false;
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

