/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class TimeToLive
extends ObjectWithReflectiveEqualsHashCodeToString {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "endDate"};
    private static final TimeToLive TIME_TO_LIVE_UNLIMITED = new TimeToLive(null, null, true){

        @Override
        public boolean stillAlive() {
            return true;
        }
    };
    private final TimeUnit timeUnit;
    private final Long timeToLive;
    private final boolean unlimited;
    private Date endDate;

    private TimeToLive(TimeUnit timeUnit, Long timeToLive, boolean unlimited) {
        this.timeUnit = timeUnit;
        this.timeToLive = timeToLive;
        this.unlimited = unlimited;
        if (!unlimited) {
            this.endDate = new Date(System.currentTimeMillis() + timeUnit.toMillis(timeToLive));
        }
    }

    public static TimeToLive unlimited() {
        return TIME_TO_LIVE_UNLIMITED;
    }

    public static TimeToLive exactly(TimeUnit timeUnit, Long timeToLive) {
        return new TimeToLive(timeUnit, timeToLive, false);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean stillAlive() {
        return this.unlimited || this.isAfterNow(this.endDate);
    }

    private boolean isAfterNow(Date date) {
        return date.getTime() > System.currentTimeMillis();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

