/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;
import org.xml.sax.SAXException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public class XmlStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger", "stringToXmlDocumentParser"};
    private final MockServerLogger mockServerLogger;
    private DiffBuilder diffBuilder;
    private NottableString matcher = NottableString.string("THIS SHOULD NEVER MATCH");
    private StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();

    public XmlStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this(mockServerLogger, NottableString.string(matcher));
    }

    public XmlStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.matcher = this.normaliseXmlNottableString(matcher);
            this.diffBuilder = DiffBuilder.compare(Input.fromString(this.matcher.getValue())).ignoreComments().ignoreWhitespace().checkForSimilar();
        }
        catch (Exception e) {
            mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Error while creating xml string matcher for [" + matcher + "]" + e.getMessage()).setThrowable(e));
        }
    }

    public String normaliseXmlString(final String input) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        return this.stringToXmlDocumentParser.normaliseXmlString(input, new StringToXmlDocumentParser.ErrorLogger(){

            @Override
            public void logError(String matched, Exception exception) {
                XmlStringMatcher.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("SAXParseException while parsing [" + input + "]").setThrowable(exception));
            }
        });
    }

    public NottableString normaliseXmlNottableString(NottableString input) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return NottableString.string(this.normaliseXmlString(input.getValue()), input.isNot());
    }

    public boolean matches(String matched) {
        return this.matches((HttpRequest)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (this.diffBuilder != null) {
            try {
                Diff diff = this.diffBuilder.withTest(Input.fromString(this.normaliseXmlString(matched.getValue()))).build();
                boolean bl = result = !diff.hasDifferences();
                if (!result) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("Failed to perform xml schema match of {} with {} because {}").setArguments(matched, this.matcher, diff.toString()));
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform xml schema match of {} with {} because {}").setArguments(matched, this.matcher, e.getMessage()));
            }
        }
        return this.matcher.isNot() == (this.not == result);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

