/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.event.Level;

public abstract class HttpForwardAction {
    protected final MockServerLogger mockServerLogger;
    private final NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    HttpForwardAction(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        this.mockServerLogger = mockServerLogger;
        this.httpClient = httpClient;
    }

    protected HttpForwardActionResult sendRequest(HttpRequest request, @Nullable InetSocketAddress remoteAddress) {
        try {
            return new HttpForwardActionResult(request, this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(request), remoteAddress), remoteAddress);
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("Exception forwarding request " + request).setThrowable(e));
            return this.notFoundFuture(request);
        }
    }

    HttpForwardActionResult notFoundFuture(HttpRequest httpRequest) {
        SettableFuture<HttpResponse> notFoundFuture = SettableFuture.create();
        notFoundFuture.set(HttpResponse.notFoundResponse());
        return new HttpForwardActionResult(httpRequest, notFoundFuture);
    }
}

