/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.scheduler;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockserver.client.SocketCommunicationException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.Delay;
import org.slf4j.event.Level;

public class Scheduler {
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(this.poolSize(), new SchedulerThreadFactory("Scheduler"), new ThreadPoolExecutor.CallerRunsPolicy());
    private final MockServerLogger mockServerLogger;

    public Scheduler(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private int poolSize() {
        return Math.max(10, Runtime.getRuntime().availableProcessors() * 2);
    }

    public synchronized void shutdown() {
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void run(Runnable command) {
        try {
            command.run();
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.INFO).setMessageFormat(throwable.getMessage()).setThrowable(throwable));
        }
    }

    public void schedule(Runnable command, boolean synchronous, Delay ... delays) {
        Delay delay = this.addDelays(delays);
        if (synchronous) {
            if (delay != null) {
                delay.applyDelay();
            }
            this.run(command);
        } else if (delay != null) {
            this.scheduler.schedule(() -> this.run(command), delay.getValue(), delay.getTimeUnit());
        } else {
            this.run(command);
        }
    }

    private Delay addDelays(Delay ... delays) {
        if (delays == null || delays.length == 0) {
            return null;
        }
        if (delays.length == 1) {
            return delays[0];
        }
        if (delays.length == 2 && delays[0] == delays[1]) {
            return delays[0];
        }
        long timeInMilliseconds = 0L;
        for (Delay delay : delays) {
            if (delay == null) continue;
            timeInMilliseconds += delay.getTimeUnit().toMillis(delay.getValue());
        }
        return new Delay(TimeUnit.MILLISECONDS, timeInMilliseconds);
    }

    public void submit(Runnable command) {
        this.submit(command, false);
    }

    public void submit(Runnable command, boolean synchronous) {
        if (synchronous) {
            this.run(command);
        } else {
            this.scheduler.submit(() -> this.run(command));
        }
    }

    public void submit(HttpForwardActionResult future, Runnable command, boolean synchronous) {
        if (future != null) {
            if (synchronous) {
                try {
                    future.getHttpResponse().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    future.getHttpResponse().setException(new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause()));
                }
                catch (InterruptedException | ExecutionException ex) {
                    future.getHttpResponse().setException(ex);
                }
                this.run(command);
            } else {
                future.getHttpResponse().addListener(command, this.scheduler);
            }
        }
    }

    public static class SchedulerThreadFactory
    implements ThreadFactory {
        private final String name;
        private static int threadInitNumber;

        public SchedulerThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("MockServer-" + this.name + threadInitNumber++);
            thread.setDaemon(true);
            return thread;
        }
    }
}

