/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.HttpRequestAndHttpResponseDTO;
import org.slf4j.event.Level;

public class HttpRequestResponseSerializer {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private final ObjectWriter objectWriter;

    public HttpRequestResponseSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withArrayIndenter(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE).withObjectIndenter(DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.objectWriter = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).writer(prettyPrinter);
    }

    public String serialize(HttpRequestAndHttpResponse httpRequestAndHttpResponse) {
        try {
            return this.objectWriter.writeValueAsString(new HttpRequestAndHttpResponseDTO(httpRequestAndHttpResponse));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + httpRequestAndHttpResponse).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + httpRequestAndHttpResponse, e);
        }
    }

    public String serialize(List<HttpRequestAndHttpResponse> httpRequestAndHttpResponses) {
        return this.serialize(httpRequestAndHttpResponses.toArray(new HttpRequestAndHttpResponse[0]));
    }

    public String serialize(HttpRequestAndHttpResponse ... httpRequestAndHttpResponses) {
        try {
            if (httpRequestAndHttpResponses != null && httpRequestAndHttpResponses.length > 0) {
                HttpRequestAndHttpResponseDTO[] httpRequestAndHttpResponseDTOS = new HttpRequestAndHttpResponseDTO[httpRequestAndHttpResponses.length];
                for (int i = 0; i < httpRequestAndHttpResponses.length; ++i) {
                    httpRequestAndHttpResponseDTOS[i] = new HttpRequestAndHttpResponseDTO(httpRequestAndHttpResponses[i]);
                }
                return this.objectWriter.writeValueAsString(httpRequestAndHttpResponseDTOS);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + Arrays.asList(httpRequestAndHttpResponses)).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpRequestAndHttpResponse to JSON with value " + Arrays.asList(httpRequestAndHttpResponses), e);
        }
    }

    public HttpRequestAndHttpResponse deserialize(String jsonHttpRequestAndHttpResponse) {
        if (StringUtils.isBlank(jsonHttpRequestAndHttpResponse)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + jsonHttpRequestAndHttpResponse + "\"");
        }
        HttpRequestAndHttpResponse httpRequestAndHttpResponse = null;
        try {
            HttpRequestAndHttpResponseDTO httpRequestAndHttpResponseDTO = this.objectMapper.readValue(jsonHttpRequestAndHttpResponse, HttpRequestAndHttpResponseDTO.class);
            if (httpRequestAndHttpResponseDTO != null) {
                httpRequestAndHttpResponse = httpRequestAndHttpResponseDTO.buildObject();
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for HttpRequestAndHttpResponse").setArguments(jsonHttpRequestAndHttpResponse).setThrowable(e));
            throw new RuntimeException("Exception while parsing [" + jsonHttpRequestAndHttpResponse + "] for HttpRequestAndHttpResponse", e);
        }
        return httpRequestAndHttpResponse;
    }

    public HttpRequestAndHttpResponse[] deserializeArray(String jsonHttpRequestAndHttpResponse) {
        ArrayList<HttpRequestAndHttpResponse> httpRequestAndHttpResponses = new ArrayList<HttpRequestAndHttpResponse>();
        if (StringUtils.isBlank(jsonHttpRequestAndHttpResponse)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + jsonHttpRequestAndHttpResponse + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.returnJSONObjects(jsonHttpRequestAndHttpResponse);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                httpRequestAndHttpResponses.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on("," + Character.NEW_LINE).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequestAndHttpResponses.toArray(new HttpRequestAndHttpResponse[0]);
    }
}

