/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.VerificationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationValidator;
import org.mockserver.verify.Verification;
import org.slf4j.event.Level;

public class VerificationSerializer
implements Serializer<Verification> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private JsonSchemaVerificationValidator verificationValidator;

    public VerificationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.verificationValidator = new JsonSchemaVerificationValidator(mockServerLogger);
    }

    @Override
    public String serialize(Verification verification) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(new VerificationDTO(verification));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing verification to JSON with value " + verification).setThrowable(e));
            throw new RuntimeException("Exception while serializing verification to JSON with value " + verification, e);
        }
    }

    @Override
    public Verification deserialize(String jsonVerification) {
        if (StringUtils.isBlank(jsonVerification)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification is required but value was \"" + String.valueOf(jsonVerification) + "\"");
        }
        String validationErrors = this.verificationValidator.isValid(jsonVerification);
        if (validationErrors.isEmpty()) {
            Verification verification = null;
            try {
                VerificationDTO verificationDTO = this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
                if (verificationDTO != null) {
                    verification = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for Verification").setArguments(jsonVerification).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonVerification + "] for Verification", e);
            }
            return verification;
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION_FAILED).setLogLevel(Level.INFO).setHttpRequest(HttpRequest.request()).setMessageFormat("validation failed:{}verification:{}").setArguments(validationErrors, jsonVerification));
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<Verification> supportsType() {
        return Verification.class;
    }
}

