/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.HttpResponseDTO;

public class HttpRequestAndHttpResponseDTO
extends ObjectWithJsonToString
implements DTO<HttpRequestAndHttpResponse> {
    private String timestamp;
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;

    public HttpRequestAndHttpResponseDTO() {
    }

    public HttpRequestAndHttpResponseDTO(HttpRequestAndHttpResponse httpRequestAndHttpResponse) {
        if (httpRequestAndHttpResponse != null) {
            HttpResponse httpResponse;
            HttpRequest httpRequest = httpRequestAndHttpResponse.getHttpRequest();
            if (httpRequest != null) {
                this.httpRequest = new HttpRequestDTO(httpRequest, httpRequest.getNot());
            }
            if ((httpResponse = httpRequestAndHttpResponse.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            this.timestamp = httpRequestAndHttpResponse.getTimestamp();
        }
    }

    @Override
    public HttpRequestAndHttpResponse buildObject() {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        return new HttpRequestAndHttpResponse().setHttpRequest(httpRequest).setHttpResponse(httpResponse).setTimestamp(this.timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
    }
}

