/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;

public class ExpectationInitializerLoader {
    private final ExpectationSerializer expectationSerializer;

    public ExpectationInitializerLoader(MockServerLogger mockServerLogger) {
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
    }

    private Expectation[] retrieveExpectationsFromInitializerClass() {
        try {
            Constructor<?> initializerClassConstructor;
            Object expectationInitializer;
            ClassLoader contextClassLoader;
            String initializationClass = ConfigurationProperties.initializationClass();
            if (StringUtils.isNotBlank(initializationClass) && (contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotEmpty(initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return ((ExpectationInitializer)expectationInitializer).initializeExpectations();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Expectation[0];
    }

    private Expectation[] retrieveExpectationsFromJson() {
        String initializationJsonPath = ConfigurationProperties.initializationJsonPath();
        if (StringUtils.isNotBlank(initializationJsonPath)) {
            return this.expectationSerializer.deserializeArray(FileReader.readFileFromClassPathOrPath(initializationJsonPath));
        }
        return new Expectation[0];
    }

    public Expectation[] loadExpectations() {
        Expectation[] expectationsFromInitializerClass = this.retrieveExpectationsFromInitializerClass();
        Expectation[] expectationsFromJson = this.retrieveExpectationsFromJson();
        return ArrayUtils.addAll(expectationsFromInitializerClass, expectationsFromJson);
    }
}

