/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;

public class NettySslContextFactory {
    private final KeyAndCertificateFactory keyAndCertificateFactory;
    private SslContext clientSslContext = null;
    private SslContext serverSslContext = null;

    public NettySslContextFactory(MockServerLogger mockServerLogger) {
        this.keyAndCertificateFactory = new KeyAndCertificateFactory(mockServerLogger);
        System.setProperty("https.protocols", "SSLv3,TLSv1,TLSv1.1,TLSv1.2,TLSv1.3");
    }

    public synchronized SslContext createClientSslContext() {
        if (this.clientSslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                this.clientSslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                ConfigurationProperties.rebuildKeyStore(false);
            }
            catch (SSLException e) {
                throw new RuntimeException("Exception creating SSL context for client", e);
            }
        }
        return this.clientSslContext;
    }

    public synchronized SslContext createServerSslContext() {
        if (this.serverSslContext == null || !this.keyAndCertificateFactory.mockServerX509CertificateCreated() || !ConfigurationProperties.preventCertificateDynamicUpdate() && ConfigurationProperties.rebuildServerKeyStore()) {
            try {
                this.keyAndCertificateFactory.buildAndSaveCertificates();
                this.serverSslContext = SslContextBuilder.forServer(this.keyAndCertificateFactory.mockServerPrivateKey(), ConfigurationProperties.javaKeyStorePassword(), this.keyAndCertificateFactory.mockServerX509Certificate(), this.keyAndCertificateFactory.mockServerCertificateAuthorityX509Certificate()).build();
                ConfigurationProperties.rebuildServerKeyStore(false);
            }
            catch (Exception e) {
                throw new RuntimeException("Exception creating SSL context for server", e);
            }
        }
        return this.serverSslContext;
    }
}

