/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherListener;

public class MockServerMatcherNotifier
extends ObjectWithReflectiveEqualsHashCodeToString {
    private boolean listenerAdded = false;
    private final List<MockServerMatcherListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerMatcherNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(MockServerMatcher notifier) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            this.scheduler.submit(() -> {
                for (MockServerMatcherListener listener : this.listeners.toArray(new MockServerMatcherListener[0])) {
                    listener.updated(notifier);
                }
            });
        }
    }

    public void registerListener(MockServerMatcherListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public void unregisterListener(MockServerMatcherListener listener) {
        this.listeners.remove(listener);
    }
}

