/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.websocket;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.mockserver.websocket.WebSocketClientHandler;
import org.mockserver.websocket.WebSocketException;
import org.slf4j.event.Level;

public class WebSocketClient<T extends HttpObject> {
    static final AttributeKey<SettableFuture<String>> REGISTRATION_FUTURE = AttributeKey.valueOf("REGISTRATION_FUTURE");
    private final MockServerLogger mockServerLogger;
    private final Semaphore availableWebSocketCallbackRegistrations;
    private Channel channel;
    private WebSocketMessageSerializer webSocketMessageSerializer;
    private ExpectationCallback<T> expectationCallback;
    private boolean isStopped = false;

    public WebSocketClient(MockServerLogger mockServerLogger, Semaphore availableWebSocketCallbackRegistrations) {
        this.mockServerLogger = mockServerLogger;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer(mockServerLogger);
        this.availableWebSocketCallbackRegistrations = availableWebSocketCallbackRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<String> register(EventLoopGroup eventLoopGroup, final InetSocketAddress serverAddress, final String contextPath, final boolean isSecure) {
        SettableFuture<String> registrationFuture = SettableFuture.create();
        if (this.availableWebSocketCallbackRegistrations.tryAcquire()) {
            try {
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).attr(REGISTRATION_FUTURE, registrationFuture)).handler(new ChannelInitializer<SocketChannel>(){

                    @Override
                    protected void initChannel(SocketChannel ch) throws URISyntaxException {
                        if (isSecure) {
                            try {
                                ch.pipeline().addLast(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc(), serverAddress.getHostName(), serverAddress.getPort()));
                            }
                            catch (SSLException e) {
                                throw new WebSocketException("Exception when configuring SSL Handler", e);
                            }
                        }
                        ch.pipeline().addLast(new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), new WebSocketClientHandler(WebSocketClient.this.mockServerLogger, serverAddress, contextPath, WebSocketClient.this));
                    }
                })).connect(serverAddress).addListener(connectChannelFuture -> {
                    this.channel = connectChannelFuture.channel();
                    this.channel.closeFuture().addListener(closeChannelFuture -> {
                        if (!this.isStopped) {
                            this.register(eventLoopGroup, serverAddress, contextPath, isSecure);
                        }
                    });
                });
            }
            catch (Exception e) {
                registrationFuture.setException(new WebSocketException("Exception while starting web socket client", e));
            }
            finally {
                this.availableWebSocketCallbackRegistrations.release();
            }
        } else {
            registrationFuture.setException(new WebSocketException("It is not possible to re-use the same MockServerClient instance to register a new object callback while responding to an object callback, please use a separate instance of the MockServerClient inside a callback"));
        }
        return registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        try {
            this.availableWebSocketCallbackRegistrations.tryAcquire();
            Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
            if (deserializedMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                if (this.expectationCallback != null) {
                    try {
                        T result = this.expectationCallback.handle(httpRequest);
                        result.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                        this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(result)));
                    }
                    catch (Throwable throwable) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(httpRequest).setMessageFormat("Exception thrown while handling callback - " + throwable.getMessage()).setThrowable(throwable));
                        this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(throwable.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                    }
                }
            } else if (!(deserializedMessage instanceof WebSocketClientIdDTO)) {
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while receiving web socket message", e);
        }
        finally {
            this.availableWebSocketCallbackRegistrations.release();
        }
    }

    public void stopClient() {
        this.isStopped = true;
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public Future<String> registerExpectationCallback(ExpectationCallback<T> expectationCallback, EventLoopGroup eventLoopGroup, InetSocketAddress serverAddress, String contextPath, boolean isSecure) {
        if (this.expectationCallback == null) {
            this.expectationCallback = expectationCallback;
            return this.register(eventLoopGroup, serverAddress, contextPath, isSecure);
        }
        throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
    }
}

