/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.websocket;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.mappers.FullHttpResponseToMockServerResponse;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.websocket.WebSocketClient;
import org.mockserver.websocket.WebSocketException;
import org.slf4j.event.Level;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final MockServerLogger mockServerLogger;
    private final ContentTypeMapper contentTypeMapper;

    WebSocketClientHandler(MockServerLogger mockServerLogger, InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient) throws URISyntaxException {
        this.mockServerLogger = mockServerLogger;
        this.contentTypeMapper = new ContentTypeMapper(mockServerLogger);
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(new URI("ws://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), WebSocketVersion.V13, null, false, new DefaultHttpHeaders(), Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.isNotBlank(contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("web socket client disconnected"));
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            SettableFuture<String> registrationFuture = ch.attr(WebSocketClient.REGISTRATION_FUTURE).get();
            if (httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                String clientRegistrationId = httpResponse.headers().get("X-CLIENT-REGISTRATION-ID");
                registrationFuture.set(clientRegistrationId);
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("web socket client " + clientRegistrationId + " connected!"));
            } else if (httpResponse.status().equals(HttpResponseStatus.NOT_IMPLEMENTED)) {
                String message = this.readRequestBody(httpResponse);
                registrationFuture.setException(new WebSocketException(message));
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setMessageFormat(message));
            } else {
                registrationFuture.setException(new WebSocketException("Unsupported web socket message " + new FullHttpResponseToMockServerResponse(this.mockServerLogger).mapMockServerResponseToFullHttpResponse(httpResponse)));
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                this.webSocketClient.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
            } else if (frame instanceof PingWebSocketFrame) {
                ctx.write(new PongWebSocketFrame(frame.content().retain()));
            } else if (frame instanceof CloseWebSocketFrame) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("web socket client received request to close"));
                ch.close();
            }
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            Charset requestCharset = this.contentTypeMapper.getCharsetFromContentTypeHeader(fullHttpResponse.headers().get(HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, requestCharset);
        }
        return "";
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("web socket client caught exception").setThrowable(cause));
        SettableFuture<String> registrationFuture = ctx.channel().attr(WebSocketClient.REGISTRATION_FUTURE).get();
        if (!registrationFuture.isDone()) {
            registrationFuture.setException(cause);
        }
        ctx.close();
    }
}

