/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.littleshoot.proxy.DefaultHttpProxyServer;
import org.littleshoot.proxy.HttpFilter;
import org.littleshoot.proxy.HttpRequestFilter;
import org.littleshoot.proxy.HttpResponseFilters;
import org.mockserver.proxy.RequestResponseLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProxy {
    private final Map<String, String> headersToAdd = new ConcurrentHashMap<String, String>();
    private final Map<String, Iterable> headersToOverride = new ConcurrentHashMap<String, Iterable>();
    private final RequestResponseLogger requestResponseLogger = new RequestResponseLogger();
    public static final String COOKIE_HEADER_NAME = "Cookie";
    private int port;
    private DefaultHttpProxyServer defaultHttpProxyServer;

    public void overrideHeader(String name, String ... values) {
        this.headersToOverride.put(name, Arrays.asList(values));
    }

    public void addHeader(String name, String value) {
        this.headersToAdd.put(name, value);
    }

    public void log(String urlRegex) {
        this.requestResponseLogger.log(urlRegex);
    }

    public void stopLogging(String urlRegex) {
        this.requestResponseLogger.stopLogging(urlRegex);
    }

    public List<HttpRequest> clearLog(String urlRegex) {
        return this.requestResponseLogger.clearLog(urlRegex);
    }

    public List<HttpRequest> getRequests(String urlRegex, Map<String, List<String>> queryParameters) {
        return this.requestResponseLogger.getRequests(urlRegex, queryParameters);
    }

    public int startProxy() {
        this.port = HttpProxy.findFreePort();
        HttpRequestFilter requestFilter = new HttpRequestFilter(){

            public void filter(HttpRequest httpRequest) {
                HttpProxy.this.addHeaders(httpRequest);
                HttpProxy.this.overrideHeaders(httpRequest);
                HttpProxy.this.requestResponseLogger.logRequestAndResponse(httpRequest);
            }
        };
        this.defaultHttpProxyServer = new DefaultHttpProxyServer(this.port, requestFilter, new HttpResponseFilters(){

            public HttpFilter getFilter(String hostAndPort) {
                return null;
            }
        });
        Thread proxyThread = new Thread(new Runnable(){

            public void run() {
                HttpProxy.this.defaultHttpProxyServer.start();
            }
        });
        proxyThread.setDaemon(true);
        proxyThread.start();
        return this.port;
    }

    public int getPort() {
        return this.port;
    }

    private void addHeaders(HttpRequest httpRequest) {
        for (String headerName : this.headersToAdd.keySet()) {
            if (headerName.equals(COOKIE_HEADER_NAME) && httpRequest.getHeader(headerName) != null) {
                this.appendCookieValue(httpRequest, headerName);
                continue;
            }
            httpRequest.addHeader(headerName, (Object)this.headersToAdd.get(headerName));
        }
    }

    private void appendCookieValue(HttpRequest httpRequest, String headerName) {
        String currentValue = httpRequest.getHeader(headerName);
        currentValue = currentValue.trim().endsWith(";") ? currentValue + " " + this.headersToAdd.get(headerName) : currentValue + "; " + this.headersToAdd.get(headerName);
        httpRequest.setHeader(headerName, (Object)currentValue);
    }

    private void overrideHeaders(HttpRequest httpRequest) {
        for (String headerName : this.headersToOverride.keySet()) {
            httpRequest.setHeader(headerName, this.headersToOverride.get(headerName));
        }
    }

    public void stopProxy() {
        if (this.defaultHttpProxyServer != null) {
            this.defaultHttpProxyServer.stop();
        }
    }

    public static int findFreePort() {
        int port = -1;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
        return port;
    }

    public String toString() {
        return this.requestResponseLogger.toString();
    }
}

