/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestResponseLogger {
    private final List<Pattern> patterns = Collections.synchronizedList(new ArrayList());
    private final Map<String, HttpRequest> requestLog = new ConcurrentHashMap<String, HttpRequest>();

    public void log(String urlRegex) {
        this.patterns.add(Pattern.compile(urlRegex));
    }

    public void stopLogging(String urlRegex) {
        for (Pattern pattern : new ArrayList<Pattern>(this.patterns)) {
            if (!pattern.pattern().equals(urlRegex)) continue;
            this.patterns.remove(pattern);
        }
    }

    public List<HttpRequest> clearLog(String urlRegex) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        Pattern urlPattern = Pattern.compile(urlRegex);
        for (String requestUrl : this.requestLog.keySet()) {
            if (!urlPattern.matcher(requestUrl).matches()) continue;
            this.requestLog.remove(requestUrl);
        }
        return httpRequests;
    }

    public List<HttpRequest> getRequests(String urlRegex, Map<String, List<String>> queryParameters) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        Pattern urlPattern = Pattern.compile(urlRegex);
        for (String requestUrl : this.requestLog.keySet()) {
            HttpRequest httpRequest;
            QueryStringDecoder queryStringDecoder;
            if (!urlPattern.matcher(requestUrl).matches() || queryParameters == null || !this.isSubMap((queryStringDecoder = new QueryStringDecoder((httpRequest = this.requestLog.get(requestUrl)).getUri())).getParameters(), queryParameters)) continue;
            httpRequests.add(this.requestLog.get(requestUrl));
        }
        return httpRequests;
    }

    private <K, V> boolean isSubMap(Map<K, V> mapToTest, Map<K, V> subMap) {
        for (K referenceKey : subMap.keySet()) {
            if (subMap.get(referenceKey).equals(mapToTest.get(referenceKey))) continue;
            return false;
        }
        return true;
    }

    void logRequestAndResponse(HttpRequest httpRequest) {
        if (this.patterns.size() > 0) {
            String host = httpRequest.getHeader("Host");
            String url = "http://" + host + httpRequest.getUri();
            for (Pattern pattern : this.patterns) {
                if (!this.shouldLog(pattern, url)) continue;
                this.requestLog.put(url, httpRequest);
            }
        }
    }

    private boolean shouldLog(Pattern pattern, String url) {
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String url : this.requestLog.keySet()) {
            stringBuilder.append("\n\n");
            stringBuilder.append(url);
            stringBuilder.append("\nREQUEST: \n");
            stringBuilder.append(this.requestLog.get(url));
        }
        return stringBuilder.toString();
    }
}

