/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.ClientSessionOptions;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DBObjects;
import com.mongodb.Function;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.SingleServerBinding;
import com.mongodb.client.ClientSession;
import com.mongodb.client.internal.MongoClientDelegate;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Connection;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.SocketStreamFactory;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.ClusterListener;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.internal.thread.DaemonThreadFactory;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CurrentOpOperation;
import com.mongodb.operation.FsyncUnlockOperation;
import com.mongodb.operation.ListDatabasesOperation;
import com.mongodb.operation.ReadOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.codecs.Decoder;

@ThreadSafe
@Deprecated
public class Mongo {
    static final String ADMIN_DATABASE_NAME = "admin";
    private final ConcurrentMap<String, DB> dbCache = new ConcurrentHashMap<String, DB>();
    private volatile WriteConcern writeConcern;
    private volatile ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final MongoClientOptions options;
    private final List<MongoCredential> credentialsList;
    private final Bytes.OptionHolder optionHolder;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final ConcurrentLinkedQueue<ServerCursorAndNamespace> orphanedCursors = new ConcurrentLinkedQueue();
    private final ExecutorService cursorCleaningService;
    private final MongoClientDelegate delegate;

    @Deprecated
    public Mongo() {
        this(new ServerAddress(), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host) {
        this(new ServerAddress(host), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host, MongoOptions options) {
        this(new ServerAddress(host), options.toClientOptions());
    }

    @Deprecated
    public Mongo(String host, int port) {
        this(new ServerAddress(host, port), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address) {
        this(address, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address, MongoOptions options) {
        this(address, options.toClientOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right) {
        this(Arrays.asList(left, right), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) {
        this(Arrays.asList(left, right), options.toClientOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds) {
        this(seeds, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds, MongoOptions options) {
        this(seeds, options.toClientOptions());
    }

    @Deprecated
    public Mongo(MongoURI uri) {
        this(uri.toClientURI());
    }

    Mongo(List<ServerAddress> seedList, MongoClientOptions options) {
        this(seedList, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, MongoClientOptions options) {
        this(serverAddress, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(serverAddress, credentialsList, options, null);
    }

    Mongo(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(serverAddress, credentialsList, options, mongoDriverInformation), options, credentialsList);
    }

    Mongo(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(seedList, credentialsList, options, null);
    }

    Mongo(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(seedList, credentialsList, options, mongoDriverInformation), options, credentialsList);
    }

    Mongo(MongoClientURI mongoURI) {
        this(mongoURI, null);
    }

    Mongo(MongoClientURI mongoURI, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(mongoURI, mongoDriverInformation), mongoURI.getOptions(), mongoURI.getCredentials() != null ? Arrays.asList(mongoURI.getCredentials()) : Collections.emptyList());
    }

    Mongo(Cluster cluster, MongoClientOptions options, List<MongoCredential> credentialsList) {
        this.options = options;
        this.readPreference = options.getReadPreference();
        this.writeConcern = options.getWriteConcern();
        this.readConcern = options.getReadConcern();
        this.optionHolder = new Bytes.OptionHolder(null);
        this.credentialsList = Collections.unmodifiableList(credentialsList);
        this.delegate = new MongoClientDelegate(cluster, credentialsList, (Object)this);
        this.cursorCleaningService = options.isCursorFinalizerEnabled() ? this.createCursorCleaningService() : null;
    }

    @Deprecated
    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Deprecated
    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Deprecated
    public List<ServerAddress> getAllAddress() {
        return this.delegate.getCluster().getSettings().getHosts();
    }

    @Deprecated
    public List<ServerAddress> getServerAddressList() {
        return this.delegate.getServerAddressList();
    }

    private ClusterDescription getClusterDescription() {
        return this.delegate.getCluster().getDescription();
    }

    @Deprecated
    @Nullable
    public ServerAddress getAddress() {
        ClusterDescription description = this.getClusterDescription();
        if (description.getPrimaries().isEmpty()) {
            return null;
        }
        return ((ServerDescription)description.getPrimaries().get(0)).getAddress();
    }

    @Deprecated
    public MongoOptions getMongoOptions() {
        return new MongoOptions(this.getMongoClientOptions());
    }

    @Deprecated
    @Nullable
    public ReplicaSetStatus getReplicaSetStatus() {
        ClusterDescription clusterDescription = this.getClusterDescription();
        return clusterDescription.getType() == ClusterType.REPLICA_SET && clusterDescription.getConnectionMode() == ClusterConnectionMode.MULTIPLE ? new ReplicaSetStatus(this.delegate.getCluster()) : null;
    }

    @Deprecated
    public List<String> getDatabaseNames() {
        return (List)new MongoIterableImpl<DBObject>(null, this.createOperationExecutor(), ReadConcern.DEFAULT, ReadPreference.primary()){

            public ReadOperation<BatchCursor<DBObject>> asReadOperation() {
                return new ListDatabasesOperation((Decoder)MongoClient.getCommandCodec());
            }
        }.map((Function)new Function<DBObject, String>(){

            public String apply(DBObject result) {
                return (String)result.get("name");
            }
        }).into(new ArrayList());
    }

    @Deprecated
    public DB getDB(String dbName) {
        DB db = (DB)this.dbCache.get(dbName);
        if (db != null) {
            return db;
        }
        db = new DB(this, dbName, this.createOperationExecutor());
        DB temp = this.dbCache.putIfAbsent(dbName, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    @Deprecated
    public Collection<DB> getUsedDatabases() {
        return this.dbCache.values();
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    public void close() {
        this.delegate.close();
        if (this.cursorCleaningService != null) {
            this.cursorCleaningService.shutdownNow();
        }
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    @Deprecated
    public void setOptions(int options) {
        this.optionHolder.set(options);
    }

    @Deprecated
    public void resetOptions() {
        this.optionHolder.reset();
    }

    @Deprecated
    public void addOption(int option) {
        this.optionHolder.add(option);
    }

    @Deprecated
    public int getOptions() {
        return this.optionHolder.get();
    }

    @Deprecated
    public CommandResult fsync(boolean async) {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        if (async) {
            command.put("async", (Object)1);
        }
        return this.getDB(ADMIN_DATABASE_NAME).command((DBObject)command);
    }

    @Deprecated
    public CommandResult fsyncAndLock() {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        command.put("lock", (Object)1);
        return this.getDB(ADMIN_DATABASE_NAME).command((DBObject)command);
    }

    @Deprecated
    public DBObject unlock() {
        return DBObjects.toDBObject((BsonDocument)this.createOperationExecutor().execute((ReadOperation)new FsyncUnlockOperation(), this.readPreference, this.readConcern));
    }

    @Deprecated
    public boolean isLocked() {
        return ((BsonDocument)this.createOperationExecutor().execute((ReadOperation)new CurrentOpOperation(), ReadPreference.primary(), this.readConcern)).getBoolean((Object)"fsyncLock", BsonBoolean.FALSE).getValue();
    }

    public String toString() {
        return "Mongo{options=" + this.getMongoClientOptions() + '}';
    }

    @Deprecated
    public int getMaxBsonObjectSize() {
        List primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : ((ServerDescription)primaries.get(0)).getMaxDocumentSize();
    }

    @Deprecated
    @Nullable
    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? String.format("%s:%d", master.getHost(), master.getPort()) : null;
    }

    private static MongoClientOptions createLegacyOptions() {
        return MongoClientOptions.builder().legacyDefaults().build();
    }

    private static Cluster createCluster(MongoClientURI mongoURI, @Nullable MongoDriverInformation mongoDriverInformation) {
        List<MongoCredential> credentialList;
        List<MongoCredential> list = credentialList = mongoURI.getCredentials() != null ? Collections.singletonList(mongoURI.getCredentials()) : Collections.emptyList();
        if (mongoURI.getHosts().size() == 1) {
            return Mongo.createCluster(ServerAddressHelper.createServerAddress((String)mongoURI.getHosts().get(0)), credentialList, mongoURI.getOptions(), null);
        }
        ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>(mongoURI.getHosts().size());
        for (String host : mongoURI.getHosts()) {
            seedList.add(ServerAddressHelper.createServerAddress((String)host));
        }
        return Mongo.createCluster(seedList, credentialList, mongoURI.getOptions(), mongoDriverInformation);
    }

    private static Cluster createCluster(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return Mongo.createCluster(Mongo.getClusterSettings(seedList, options, ClusterConnectionMode.MULTIPLE), credentialsList, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return Mongo.createCluster(Mongo.getClusterSettings(Collections.singletonList(serverAddress), options, Mongo.getSingleServerClusterMode(options)), credentialsList, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ClusterSettings clusterSettings, List<MongoCredential> credentialsList, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        return new DefaultClusterFactory().createCluster(clusterSettings, options.getServerSettings(), options.getConnectionPoolSettings(), (StreamFactory)new SocketStreamFactory(options.getSocketSettings(), options.getSslSettings(), options.getSocketFactory()), (StreamFactory)new SocketStreamFactory(options.getHeartbeatSocketSettings(), options.getSslSettings(), options.getSocketFactory()), credentialsList, EventListenerHelper.getCommandListener(options.getCommandListeners()), options.getApplicationName(), mongoDriverInformation, options.getCompressorList());
    }

    private static ClusterSettings getClusterSettings(List<ServerAddress> seedList, MongoClientOptions options, ClusterConnectionMode clusterConnectionMode) {
        ClusterSettings.Builder builder = ClusterSettings.builder().hosts(new ArrayList<ServerAddress>(seedList)).mode(clusterConnectionMode).requiredReplicaSetName(options.getRequiredReplicaSetName()).serverSelectionTimeout((long)options.getServerSelectionTimeout(), TimeUnit.MILLISECONDS).localThreshold((long)options.getLocalThreshold(), TimeUnit.MILLISECONDS).serverSelector(options.getServerSelector()).description(options.getDescription()).maxWaitQueueSize(options.getConnectionPoolSettings().getMaxWaitQueueSize());
        for (ClusterListener clusterListener : options.getClusterListeners()) {
            builder.addClusterListener(clusterListener);
        }
        return builder.build();
    }

    Cluster getCluster() {
        return this.delegate.getCluster();
    }

    ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    Bytes.OptionHolder getOptionHolder() {
        return this.optionHolder;
    }

    BufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    MongoClientOptions getMongoClientOptions() {
        return this.options;
    }

    List<MongoCredential> getCredentialsList() {
        return this.credentialsList;
    }

    void addOrphanedCursor(ServerCursor serverCursor, MongoNamespace namespace) {
        this.orphanedCursors.add(new ServerCursorAndNamespace(serverCursor, namespace));
    }

    OperationExecutor createOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    @Nullable
    ClientSession createClientSession(ClientSessionOptions options) {
        return this.delegate.createClientSession(options, this.readConcern, this.writeConcern, this.readPreference);
    }

    private ExecutorService createCursorCleaningService() {
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("CleanCursors"));
        newTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Mongo.this.cleanCursors();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        return newTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCursors() {
        ServerCursorAndNamespace cur;
        while ((cur = this.orphanedCursors.poll()) != null) {
            SingleServerBinding binding = new SingleServerBinding(this.delegate.getCluster(), cur.serverCursor.getAddress());
            try {
                ConnectionSource source = binding.getReadConnectionSource();
                try {
                    Connection connection = source.getConnection();
                    try {
                        connection.killCursor(cur.namespace, Collections.singletonList(cur.serverCursor.getId()));
                    }
                    finally {
                        connection.release();
                    }
                }
                finally {
                    source.release();
                }
            }
            finally {
                binding.release();
            }
        }
    }

    private static ClusterConnectionMode getSingleServerClusterMode(MongoClientOptions options) {
        if (options.getRequiredReplicaSetName() == null) {
            return ClusterConnectionMode.SINGLE;
        }
        return ClusterConnectionMode.MULTIPLE;
    }

    @Deprecated
    public static class Holder {
        private static final Holder INSTANCE = new Holder();
        private final ConcurrentMap<String, Mongo> clients = new ConcurrentHashMap<String, Mongo>();

        public static Holder singleton() {
            return INSTANCE;
        }

        @Deprecated
        public Mongo connect(MongoURI uri) {
            return this.connect(uri.toClientURI());
        }

        public Mongo connect(MongoClientURI uri) {
            String key = this.toKey(uri);
            Mongo client = (Mongo)this.clients.get(key);
            if (client == null) {
                MongoClient newbie = new MongoClient(uri);
                client = this.clients.putIfAbsent(key, newbie);
                if (client == null) {
                    client = newbie;
                } else {
                    newbie.close();
                }
            }
            return client;
        }

        private String toKey(MongoClientURI uri) {
            return uri.toString();
        }
    }

    private static class ServerCursorAndNamespace {
        private final ServerCursor serverCursor;
        private final MongoNamespace namespace;

        ServerCursorAndNamespace(ServerCursor serverCursor, MongoNamespace namespace) {
            this.serverCursor = serverCursor;
            this.namespace = namespace;
        }
    }
}

