/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.StorageUtils;
import org.moskito.central.storage.fs.CSVFileStorageConfig;
import org.moskito.central.storage.serializer.CSVSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileStorage
implements Storage {
    private CSVFileStorageConfig config;
    private static Logger log = LoggerFactory.getLogger(CSVFileStorage.class);
    private CSVSerializer serializer = new CSVSerializer();

    public void configure(String configurationName) {
        this.config = new CSVFileStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException e) {
            log.warn("Couldn't configure CSVFileStorage with " + configurationName + " , working with default values");
        }
        log.info("Configured CSVFIleStorage " + this.config + " from configuration file " + configurationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSnapshot(Snapshot target) {
        String producerId = target.getMetaData().getProducerId();
        String interval = target.getMetaData().getIntervalName();
        Set stats = target.getKeySet();
        if (stats == null || stats.size() == 0) {
            return;
        }
        for (String stat : stats) {
            byte[] data;
            if (!this.config.include(producerId, stat, interval) || (data = this.serializer.serialize(target, stat)) == null) continue;
            String path = StorageUtils.convertPathPattern((String)this.config.getPattern(), (Snapshot)target, (String)stat);
            FileOutputStream fOut = null;
            String dirName = path.substring(0, path.lastIndexOf(47));
            File f = new File(dirName);
            f.mkdirs();
            File targetFile = new File(path);
            boolean writeHeader = !targetFile.exists();
            try {
                fOut = new FileOutputStream(targetFile, true);
                if (writeHeader) {
                    fOut.write(this.serializer.getHeader(target));
                    fOut.write("\n".getBytes());
                }
                fOut.write(data);
                fOut.write("\n".getBytes());
                fOut.flush();
            }
            catch (IOException e) {
                log.error("can't serialize snapshot " + target, (Throwable)e);
            }
            finally {
                if (fOut == null) continue;
                try {
                    fOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

