/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.SnapshotSerializer;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.StorageUtils;
import org.moskito.central.storage.fs.FileSystemStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemStorage
implements Storage {
    private SnapshotSerializer serializer;
    private FileSystemStorageConfig config;
    private static Logger log = LoggerFactory.getLogger(FileSystemStorage.class);

    public void configure(String configurationName) {
        this.config = new FileSystemStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException e) {
            log.warn("Couldn't configure FileSystemStorage with " + configurationName + " , working with default values");
        }
        try {
            this.serializer = (SnapshotSerializer)SnapshotSerializer.class.cast(Class.forName(this.config.getSerializer()).newInstance());
        }
        catch (Exception e) {
            log.error("can't instantiate serializer " + this.serializer + " of class " + this.config.getSerializer(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSnapshot(Snapshot target) {
        if (!this.config.include(target.getMetaData().getProducerId(), target.getMetaData().getIntervalName())) {
            return;
        }
        if (this.serializer == null) {
            log.warn("can't serialize snapshots, ignoring " + target);
            return;
        }
        byte[] data = this.serializer.serialize(target);
        String path = StorageUtils.convertPathPattern((String)this.config.getPattern(), (Snapshot)target);
        FileOutputStream fOut = null;
        String dirName = path.substring(0, path.lastIndexOf(47));
        File f = new File(dirName);
        f.mkdirs();
        try {
            fOut = new FileOutputStream(path);
            fOut.write(data);
            fOut.flush();
        }
        catch (IOException e) {
            log.error("can't serialize snapshot " + target, (Throwable)e);
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

