/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.fs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.moskito.central.storage.fs.IncludeExcludeList;

public class IncludeExcludeWildcardList
extends IncludeExcludeList {
    private List<Pattern> includePatterns = new ArrayList<Pattern>();
    private List<Pattern> excludePatterns = new ArrayList<Pattern>();

    public IncludeExcludeWildcardList(String include, String exclude) {
        super(include, exclude);
        this.fillPatterns(this.getIncludes(), this.includePatterns);
        this.fillPatterns(this.getExcludes(), this.excludePatterns);
    }

    private void fillPatterns(Set<String> set, List<Pattern> patterns) {
        for (String incl : set) {
            String s = incl;
            if (s.contains("*")) {
                s = s.replaceAll("\\*", ".*");
            }
            if (s.contains("?")) {
                s = s.replaceAll("\\?", ".{1}");
            }
            patterns.add(Pattern.compile("^" + s + "$"));
        }
    }

    @Override
    public boolean include(String query) {
        boolean exactMatch = super.include(query);
        if (exactMatch) {
            return true;
        }
        if (!exactMatch && this.getExcludes().contains(query)) {
            return false;
        }
        for (Pattern p : this.excludePatterns) {
            if (!p.matcher(query).find()) continue;
            return false;
        }
        for (Pattern p : this.includePatterns) {
            if (!p.matcher(query).find()) continue;
            return true;
        }
        return false;
    }
}

