/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.tsdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.fs.IncludeExcludeList;
import org.moskito.central.storage.tsdb.OpenTSDBStorageConfigEntry;

@ConfigureMe
public class OpenTSDBStorageConfig {
    @Configure
    private String url;
    @Configure
    private OpenTSDBStorageConfigEntry[] entries;
    private List<OpenTSDBStorageConfigElement> elements;
    @Configure
    private String includeIntervals = "*";
    @Configure
    private String excludeIntervals = "";

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public OpenTSDBStorageConfigEntry[] getEntries() {
        return this.entries;
    }

    public void setEntries(OpenTSDBStorageConfigEntry[] entries) {
        this.entries = entries;
    }

    public String toString() {
        return "Url: " + this.getUrl() + ", Entries: " + Arrays.toString(this.entries) + ", InclIntervals: " + this.includeIntervals + ", ExclIntervals: " + this.excludeIntervals;
    }

    public boolean include(String producer, String stat, String interval) {
        List<OpenTSDBStorageConfigElement> listCopy = this.elements;
        if (listCopy == null) {
            return false;
        }
        for (OpenTSDBStorageConfigElement e : listCopy) {
            if (!e.include(producer, stat, interval)) continue;
            return true;
        }
        return false;
    }

    @AfterConfiguration
    public void afterConfig() {
        IncludeExcludeList intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        ArrayList<OpenTSDBStorageConfigElement> newElements = new ArrayList<OpenTSDBStorageConfigElement>();
        for (OpenTSDBStorageConfigEntry entry : this.entries) {
            OpenTSDBStorageConfigElement element = new OpenTSDBStorageConfigElement(entry, intervals);
            newElements.add(element);
        }
        this.elements = newElements;
    }

    private static class OpenTSDBStorageConfigElement {
        private IncludeExcludeList intervals;
        private IncludeExcludeList producers;
        private IncludeExcludeList stats;

        public OpenTSDBStorageConfigElement(OpenTSDBStorageConfigEntry entry, IncludeExcludeList outerIntervals) {
            this.stats = new IncludeExcludeList(entry.getIncludedStats(), entry.getExcludedStats());
            this.producers = new IncludeExcludeList(entry.getIncludedProducers(), entry.getExcludedProducers());
            this.intervals = !(entry.getIncludedIntervals() != null && entry.getIncludedIntervals().length() != 0 || entry.getExcludedIntervals() != null && entry.getExcludedIntervals().length() != 0) ? outerIntervals : new IncludeExcludeList(entry.getIncludedIntervals(), entry.getExcludedIntervals());
        }

        public boolean include(String producer, String stat, String interval) {
            return this.producers.include(producer) && this.stats.include(stat) && this.intervals.include(interval);
        }

        public String toString() {
            return "OpenTSDBStorageConfigElement{intervals=" + this.intervals + ", producers=" + this.producers + ", stats=" + this.stats + '}';
        }
    }
}

