/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.common;

import java.util.ArrayList;
import java.util.List;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.common.IncludeExcludeFields;
import org.moskito.central.storage.common.StorageConfigElement;
import org.moskito.central.storage.common.StorageConfigEntry;
import org.moskito.central.storage.helpers.IncludeExcludeList;

@ConfigureMe
public class GenericStorageConfig {
    @Configure
    protected StorageConfigEntry[] entries;
    protected List<StorageConfigElement> elements;
    @Configure
    protected String includeIntervals = "*";
    @Configure
    protected String excludeIntervals = "";

    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    public StorageConfigEntry[] getEntries() {
        return this.entries;
    }

    public void setEntries(StorageConfigEntry[] entries) {
        this.entries = entries;
    }

    public boolean include(IncludeExcludeFields fields) {
        for (StorageConfigElement element : this.elements) {
            if (!element.include(fields)) continue;
            return true;
        }
        return false;
    }

    @AfterConfiguration
    public void afterConfiguration() {
        IncludeExcludeList intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        this.elements = this.prepareStorageConfigElements(intervals);
    }

    private List<StorageConfigElement> prepareStorageConfigElements(IncludeExcludeList intervals) {
        ArrayList<StorageConfigElement> newElements = new ArrayList<StorageConfigElement>();
        if (this.entries == null) {
            return newElements;
        }
        StorageConfigEntry[] storageConfigEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            StorageConfigEntry entry = storageConfigEntryArray[n2];
            StorageConfigElement element = new StorageConfigElement(entry, intervals);
            newElements.add(element);
            ++n2;
        }
        return newElements;
    }
}

