/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.common;

import org.moskito.central.storage.common.IncludeExcludeFields;
import org.moskito.central.storage.common.StorageConfigEntry;
import org.moskito.central.storage.helpers.IncludeExcludeList;
import org.moskito.central.storage.helpers.IncludeExcludeWildcardList;

public class StorageConfigElement {
    private IncludeExcludeList intervals;
    private IncludeExcludeWildcardList producers;
    private IncludeExcludeWildcardList categories;
    private IncludeExcludeWildcardList subsystems;

    public StorageConfigElement(StorageConfigEntry entry, IncludeExcludeList outerIntervals) {
        this.categories = new IncludeExcludeWildcardList(entry.getIncludedCategories(), entry.getExcludedCategories());
        this.producers = new IncludeExcludeWildcardList(entry.getIncludedProducers(), entry.getExcludedProducers());
        this.subsystems = new IncludeExcludeWildcardList(entry.getIncludedSubsystems(), entry.getExcludedSubsystems());
        this.intervals = !(entry.getIncludedIntervals() != null && entry.getIncludedIntervals().length() != 0 || entry.getExcludedIntervals() != null && entry.getExcludedIntervals().length() != 0) ? outerIntervals : new IncludeExcludeList(entry.getIncludedIntervals(), entry.getExcludedIntervals());
    }

    public boolean include(IncludeExcludeFields fields) {
        return this.producers.include(fields.getProducer()) && this.categories.include(fields.getCategory()) && this.intervals.include(fields.getInterval()) && this.subsystems.include(fields.getSubsystem());
    }

    public String toString() {
        return "StorageConfigElement{intervals=" + this.intervals + ", producers=" + this.producers + ", categories=" + this.categories + ", subsystems=" + this.subsystems + '}';
    }
}

