/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.configureme.ConfigurationManager;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.elasticsearch.ElasticsearchStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchStorage
implements Storage {
    private static Logger log = LoggerFactory.getLogger(ElasticsearchStorage.class);
    private ElasticsearchStorageConfig config;
    private Client transportClient;
    private CloseableHttpClient httpClient;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void configure(String configurationName) {
        this.config = new ElasticsearchStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Couldn't configure ElasticsearchStorage with " + configurationName + " , working with default values");
        }
        if (this.config.getProxy().equals("true") && this.config.getApi().equals("http")) {
            this.config.setPort("");
        } else if (!this.config.getApi().equals("java")) {
            this.config.setHost(String.valueOf(this.config.getHost()) + ":");
        }
        if (this.config.getApi().equals("java")) {
            this.transportClient = this.getTransportClient();
        } else if (this.config.getApi().equals("http")) {
            this.httpClient = this.getHttpClient();
            this.httpPrepareIndex();
        } else {
            log.error("API isn't defined, couldn't configure ElasticsearchStorage");
        }
    }

    public void processSnapshot(Snapshot target) {
        String interval;
        String producerId = target.getMetaData().getProducerId();
        if (!this.config.include(producerId, interval = target.getMetaData().getIntervalName())) {
            return;
        }
        if (this.transportClient != null) {
            this.transportProcessSnapshot(target);
        } else if (this.httpClient != null) {
            this.httpProcessSnapshot(target);
        } else {
            log.error("API isn't defined, couldn't process Snapshot");
        }
    }

    private void transportProcessSnapshot(Snapshot target) {
        IndexResponse response = (IndexResponse)this.transportClient.prepareIndex(this.config.getIndex(), target.getMetaData().getProducerId().replaceAll(" ", "")).setSource(this.gson.toJson((Object)target)).execute().actionGet();
        log.debug("Stored:" + response.getId());
    }

    private void httpProcessSnapshot(Snapshot target) {
        this.httpClient = HttpClients.createDefault();
        HttpPost post = new HttpPost(String.valueOf(this.config.getHost()) + this.config.getPort() + "/" + this.config.getIndex() + "/" + target.getMetaData().getProducerId().replaceAll(" ", ""));
        try {
            StringEntity entity = new StringEntity(this.gson.toJson((Object)target));
            entity.setContentType("application/json");
            post.setEntity((HttpEntity)entity);
            this.httpClient.execute((HttpUriRequest)post);
            this.httpClient.close();
        }
        catch (Exception e) {
            log.warn("Couldn't process Snapshot: ", (Throwable)e);
        }
    }

    private Client getTransportClient() {
        if (this.transportClient == null) {
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.config.getClusterName()).build();
            this.transportClient = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.config.getHost(), Integer.parseInt(this.config.getPort())));
        }
        return this.transportClient;
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return this.httpClient;
    }

    private void httpPrepareIndex() {
        HttpPut put = new HttpPut(String.valueOf(this.config.getHost()) + this.config.getPort() + "/" + this.config.getIndex());
        try {
            this.httpClient.execute((HttpUriRequest)put);
            this.httpClient.close();
        }
        catch (IOException e) {
            log.warn("Can't prepare index", (Throwable)e);
        }
    }
}

