/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.elasticsearch;

import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.helpers.IncludeExcludeList;

@ConfigureMe
public class ElasticsearchStorageConfig {
    @Configure
    private String host;
    @Configure
    private String port;
    @Configure
    private String api;
    @Configure
    private String proxy;
    @Configure
    private String clusterName;
    @Configure
    private String index;
    @Configure
    private String includeProducers = "*";
    @Configure
    private String excludeProducers = "";
    @Configure
    private String includeIntervals = "*";
    @Configure
    private String excludeIntervals = "";
    private IncludeExcludeList intervals;
    private IncludeExcludeList producers;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getIncludeProducers() {
        return this.includeProducers;
    }

    public void setIncludeProducers(String includeProducers) {
        this.includeProducers = includeProducers;
    }

    public String getExcludeProducers() {
        return this.excludeProducers;
    }

    public void setExcludeProducers(String excludeProducers) {
        this.excludeProducers = excludeProducers;
    }

    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public IncludeExcludeList getIntervals() {
        return this.intervals;
    }

    public void setIntervals(IncludeExcludeList intervals) {
        this.intervals = intervals;
    }

    public IncludeExcludeList getProducers() {
        return this.producers;
    }

    public void setProducers(IncludeExcludeList producers) {
        this.producers = producers;
    }

    @AfterConfiguration
    public void afterConfiguration() {
        this.intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        this.producers = new IncludeExcludeList(this.includeProducers, this.excludeProducers);
    }

    public boolean include(String producerId, String intervalName) {
        if (!this.intervals.include(intervalName)) {
            return false;
        }
        return this.producers.include(producerId);
    }

    public String toString() {
        return "ElasticsearchStorageConfig{host='" + this.host + '\'' + ", port='" + this.port + '\'' + ", api='" + this.api + '\'' + ", proxy='" + this.proxy + '\'' + ", index='" + this.index + '\'' + ", includeProducers='" + this.includeProducers + '\'' + ", excludeProducers='" + this.excludeProducers + '\'' + ", includeIntervals='" + this.includeIntervals + '\'' + ", excludeIntervals='" + this.excludeIntervals + '\'' + '}';
    }
}

