/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.fs;

import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.common.GenericStorageConfig;
import org.moskito.central.storage.common.IncludeExcludeFields;
import org.moskito.central.storage.helpers.IncludeExcludeList;

@ConfigureMe
public class FileSystemStorageConfig
extends GenericStorageConfig {
    @Configure
    private String serializer;
    @Configure
    private String includeProducers = "*";
    @Configure
    private String excludeProducers = "";
    @Configure
    private String pattern = "/tmp/central/{host}/{component}/{producer}/{date}/{date}_{time}_{producer}.json";
    @Configure
    private String includeIntervals = "*";
    @Configure
    private String excludeIntervals = "";
    private IncludeExcludeList intervals;
    private IncludeExcludeList producers;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    @Override
    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    @Override
    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    @Override
    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public void setSerializer(String serializer) {
        this.serializer = serializer;
    }

    public String getIncludeProducers() {
        return this.includeProducers;
    }

    public void setIncludeProducers(String includeProducers) {
        this.includeProducers = includeProducers;
    }

    public String getExcludeProducers() {
        return this.excludeProducers;
    }

    public void setExcludeProducers(String excludeProducers) {
        this.excludeProducers = excludeProducers;
    }

    @Override
    @AfterConfiguration
    public void afterConfiguration() {
        super.afterConfiguration();
        this.intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        this.producers = new IncludeExcludeList(this.includeProducers, this.excludeProducers);
    }

    public String toString() {
        return "Pat: " + this.getPattern() + ", InclIntervals: " + this.getIncludeIntervals() + ", ExclIntervals: " + this.getExcludeIntervals() + ", Ser: " + this.getSerializer() + ", InclProducers: " + this.getIncludeProducers() + ", ExclProducers: " + this.getExcludeProducers();
    }

    public boolean include(IncludeExcludeFields fields, String producerId, String intervalName) {
        if (!super.include(fields)) {
            return false;
        }
        if (!this.intervals.include(intervalName)) {
            return false;
        }
        return this.producers.include(producerId);
    }
}

