/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.graylog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.common.IncludeExcludeFields;
import org.moskito.central.storage.graylog.GraylogStorageConfig;
import org.moskito.central.storage.graylog.SnapshotGelf;
import org.moskito.central.storage.graylog.SnapshotGelfBuilder;
import org.moskito.central.storage.helpers.SnapshotWithStatsNumbers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraylogStorage
implements Storage {
    private static Logger log = LoggerFactory.getLogger(GraylogStorage.class);
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private GraylogStorageConfig config;
    private CloseableHttpClient httpClient;

    public void configure(String configurationName) {
        this.config = new GraylogStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException e) {
            log.error("Couldn't configure GraylogStorage with " + configurationName, (Throwable)e);
        }
    }

    private void createHttpClient() {
        if (this.httpClient == null) {
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(200);
            cm.setDefaultMaxPerRoute(20);
            HttpHost graylogHost = new HttpHost(this.config.getHost(), this.config.getPort());
            cm.setMaxPerRoute(new HttpRoute(graylogHost), 50);
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
    }

    public void processSnapshot(Snapshot target) {
        String producerId = target.getMetaData().getProducerId();
        String category = target.getMetaData().getCategory();
        String subsystem = target.getMetaData().getSubsystem();
        String interval = target.getMetaData().getIntervalName();
        IncludeExcludeFields fields = new IncludeExcludeFields.Builder().setProducer(producerId).setCategory(category).setSubsystem(subsystem).setInterval(interval).build();
        log.info(this.config.toString());
        if (this.config.include(fields)) {
            this.createHttpClient();
            HttpPost request = new HttpPost(String.valueOf(this.config.getHost()) + ':' + this.config.getPort() + '/' + this.config.getPath());
            try {
                try {
                    String message = this.gson.toJson((Object)new SnapshotWithStatsNumbers(target));
                    SnapshotGelf snapshotGelf = new SnapshotGelfBuilder().host(InetAddress.getLocalHost().getHostName()).shortMessage("moskito logs").message(message).build();
                    StringEntity params = new StringEntity(this.gson.toJson((Object)snapshotGelf));
                    request.addHeader("content-type", "application/x-www-form-urlencoded");
                    request.setEntity((HttpEntity)params);
                    this.httpClient.execute((HttpUriRequest)request);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    log.error("GraylogPublisher.sendMessage(): couldn't create StringEntity");
                    request.releaseConnection();
                    try {
                        this.httpClient.close();
                        this.httpClient = null;
                    }
                    catch (IOException e) {
                        log.error("couldn't close connecion to graylog server", (Throwable)e);
                    }
                }
                catch (IOException iOException) {
                    log.error("GraylogPublisher.sendMessage(): couldn't execute query");
                    request.releaseConnection();
                    try {
                        this.httpClient.close();
                        this.httpClient = null;
                    }
                    catch (IOException e) {
                        log.error("couldn't close connecion to graylog server", (Throwable)e);
                    }
                }
            }
            finally {
                request.releaseConnection();
                try {
                    this.httpClient.close();
                    this.httpClient = null;
                }
                catch (IOException e) {
                    log.error("couldn't close connecion to graylog server", (Throwable)e);
                }
            }
        }
    }
}

