/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.graylog;

import java.util.Arrays;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.common.GenericStorageConfig;

@ConfigureMe
public class GraylogStorageConfig
extends GenericStorageConfig {
    public static final String HTTP_PREFIX = "http://";
    @Configure
    private String host;
    @Configure
    private int port;
    @Configure
    private String path = "gelf";

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (!host.startsWith(HTTP_PREFIX)) {
            host = HTTP_PREFIX + host;
        }
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    @AfterConfiguration
    public void afterConfiguration() {
        super.afterConfiguration();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GraylogStorageConfig{");
        sb.append("host='").append(this.host).append('\'');
        sb.append(", port=").append(this.port);
        sb.append(", path='").append(this.path).append('\'');
        sb.append(", entries=").append(Arrays.toString(this.entries));
        sb.append(", elements=").append(this.elements);
        sb.append(", includeIntervals='").append(this.includeIntervals).append('\'');
        sb.append(", excludeIntervals='").append(this.excludeIntervals).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

