/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.graylog;

import java.util.HashMap;
import java.util.Map;
import org.moskito.central.storage.graylog.SnapshotGelf;

public class SnapshotGelfBuilder {
    private final String version = "1.1";
    private String host;
    private String short_message;
    private String message;
    private Map<String, Object> fields = new HashMap<String, Object>();

    public SnapshotGelfBuilder message(String message) {
        this.message = message;
        return this;
    }

    public SnapshotGelfBuilder host(String host) {
        this.host = host;
        return this;
    }

    public SnapshotGelfBuilder shortMessage(String short_message) {
        this.short_message = short_message;
        return this;
    }

    public SnapshotGelfBuilder additionalField(String key, Object value) {
        this.fields.put(key, value);
        return this;
    }

    public SnapshotGelfBuilder additionalFields(Map<String, Object> additionalFields) {
        this.fields.putAll(additionalFields);
        return this;
    }

    public String getVersion() {
        return "1.1";
    }

    public String getHost() {
        return this.host;
    }

    public String getShortMessage() {
        return this.short_message;
    }

    public String getMessage() {
        return this.message;
    }

    public SnapshotGelf build() {
        if (this.message == null) {
            throw new IllegalArgumentException("message must not be null!");
        }
        if (this.host == null || this.host.trim().isEmpty()) {
            throw new IllegalArgumentException("host must not be null or empty!");
        }
        SnapshotGelf snapshotGelf = new SnapshotGelf();
        snapshotGelf.setHost(this.host);
        snapshotGelf.setShortMessage(this.short_message);
        snapshotGelf.setData(this.message);
        return snapshotGelf;
    }
}

