/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.helpers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.moskito.central.Snapshot;
import org.moskito.central.SnapshotMetaData;

public class SnapshotWithStatsNumbers
implements Serializable {
    private static final long serialVersionUID = 5908354352999422349L;
    @XmlElement(name="snshmd")
    private SnapshotMetaData metaData;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Map<String, Map<String, Double>> stats = new HashMap<String, Map<String, Double>>();

    public SnapshotWithStatsNumbers() {
    }

    public SnapshotWithStatsNumbers(Snapshot snapshot) {
        this.metaData = snapshot.getMetaData();
        this.stats = this.convertStats(snapshot.getStats());
    }

    private Map<String, Map<String, Double>> convertStats(Map<String, Map<String, String>> stats) {
        HashMap<String, Map<String, Double>> res = new HashMap<String, Map<String, Double>>();
        for (String s : stats.keySet()) {
            res.put(s, this.convertStatsValueMap(stats.get(s)));
        }
        return res;
    }

    private Map<String, Double> convertStatsValueMap(Map<String, String> stringStringMap) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        for (String s : stringStringMap.keySet()) {
            if (stringStringMap.get(s).equals("NaN")) {
                res.put(s, 0.0);
                continue;
            }
            res.put(s, Double.parseDouble(stringStringMap.get(s)));
        }
        return res;
    }

    public SnapshotMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(SnapshotMetaData metaData) {
        this.metaData = metaData;
    }

    public void addSnapshotData(String name, Map<String, Double> values) {
        this.stats.put(name, values);
    }

    public String toString() {
        return "Snapshot [metaData=" + this.metaData + ", stats=" + this.stats + "]";
    }

    public Map<String, Double> getStatistics(String stat) {
        return this.stats.get(stat);
    }

    public Set<Map.Entry<String, Map<String, Double>>> getEntrySet() {
        return this.stats.entrySet();
    }

    public Set<String> getKeySet() {
        return this.stats.keySet();
    }

    public Map<String, Map<String, Double>> getStats() {
        if (this.stats == null) {
            this.stats = new HashMap<String, Map<String, Double>>();
        }
        return this.stats;
    }

    public void setStats(Map<String, Map<String, Double>> stats) {
        this.stats = stats;
    }

    public static class MapAdapter
    extends org.moskito.central.MapAdapter<String, Map<String, String>> {
    }
}

