/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.mongo;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Arrays;
import org.bson.Document;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.mongo.MongoDBStorageConfig;

public enum MongoClientHolder {
    INSTANCE;

    private Gson gson = new GsonBuilder().create();
    private MongoDBStorageConfig config;
    private MongoClient client;

    public void configure(MongoDBStorageConfig config) {
        this.config = config;
        MongoCredential credential = MongoCredential.createCredential((String)config.getLogin(), (String)config.getDbName(), (char[])config.getPassword().toCharArray());
        this.client = new MongoClient(new ServerAddress(config.getHost(), Integer.parseInt(config.getPort())), Arrays.asList(credential));
    }

    public void storeSnapshot(Snapshot target) {
        MongoDatabase db = this.client.getDatabase(this.config.getDbName());
        MongoCollection collection = db.getCollection(this.config.getCollectionName());
        String json = this.gson.toJson((Object)target);
        collection.insertOne((Object)Document.parse((String)json));
    }
}

