/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.mongo;

import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.mongo.MongoClientHolder;
import org.moskito.central.storage.mongo.MongoDBStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBStorage
implements Storage {
    private static Logger log = LoggerFactory.getLogger(MongoDBStorage.class);
    private MongoDBStorageConfig config;

    public void configure(String configurationName) {
        this.config = new MongoDBStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
            MongoClientHolder.INSTANCE.configure(this.config);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Couldn't configure MongoDBStorage with " + configurationName + " , working with default values");
        }
    }

    public void processSnapshot(Snapshot target) {
        String interval;
        String producerId = target.getMetaData().getProducerId();
        if (!this.config.include(producerId, interval = target.getMetaData().getIntervalName())) {
            return;
        }
        if (this.config.getHost() == null || this.config.getPort() == null) {
            log.warn("No hostname, can not save snapshot");
            return;
        }
        if (this.config.getDistributeProducers().equals("true")) {
            this.config.setCollectionName(target.getMetaData().getProducerId());
        }
        MongoClientHolder.INSTANCE.storeSnapshot(target);
    }
}

