/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.mongo;

import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.moskito.central.storage.helpers.IncludeExcludeList;

@ConfigureMe
public class MongoDBStorageConfig {
    @Configure
    private String host;
    @Configure
    private String port;
    @Configure
    private String dbName;
    @Configure
    private String login;
    @Configure
    private String password;
    @Configure
    private String collectionName;
    @Configure
    private String distributeProducers;
    @Configure
    private String includeProducers = "*";
    @Configure
    private String excludeProducers = "";
    @Configure
    private String includeIntervals = "*";
    @Configure
    private String excludeIntervals = "";
    private IncludeExcludeList intervals;
    private IncludeExcludeList producers;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getDistributeProducers() {
        return this.distributeProducers;
    }

    public void setDistributeProducers(String distributeProducers) {
        this.distributeProducers = distributeProducers;
    }

    public String getIncludeProducers() {
        return this.includeProducers;
    }

    public void setIncludeProducers(String includeProducers) {
        this.includeProducers = includeProducers;
    }

    public String getExcludeProducers() {
        return this.excludeProducers;
    }

    public void setExcludeProducers(String excludeProducers) {
        this.excludeProducers = excludeProducers;
    }

    public String getIncludeIntervals() {
        return this.includeIntervals;
    }

    public void setIncludeIntervals(String includeIntervals) {
        this.includeIntervals = includeIntervals;
    }

    public String getExcludeIntervals() {
        return this.excludeIntervals;
    }

    public void setExcludeIntervals(String excludeIntervals) {
        this.excludeIntervals = excludeIntervals;
    }

    public IncludeExcludeList getIntervals() {
        return this.intervals;
    }

    public void setIntervals(IncludeExcludeList intervals) {
        this.intervals = intervals;
    }

    public IncludeExcludeList getProducers() {
        return this.producers;
    }

    public void setProducers(IncludeExcludeList producers) {
        this.producers = producers;
    }

    @AfterConfiguration
    public void afterConfiguration() {
        this.intervals = new IncludeExcludeList(this.includeIntervals, this.excludeIntervals);
        this.producers = new IncludeExcludeList(this.includeProducers, this.excludeProducers);
    }

    public boolean include(String producerId, String intervalName) {
        if (!this.intervals.include(intervalName)) {
            return false;
        }
        return this.producers.include(producerId);
    }

    public String toString() {
        return "MongoDBStorageConfig{host='" + this.host + '\'' + ", dbName='" + this.dbName + '\'' + ", login='" + this.login + '\'' + ", password='" + this.password + '\'' + ", collectionName='" + this.collectionName + '\'' + ", includeProducers='" + this.includeProducers + '\'' + ", excludeProducers='" + this.excludeProducers + '\'' + ", includeIntervals='" + this.includeIntervals + '\'' + ", excludeIntervals='" + this.excludeIntervals + '\'' + ", intervals=" + this.intervals + ", producers=" + this.producers + '}';
    }
}

