/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.storage.psql;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.storage.Storage;
import org.moskito.central.storage.psql.PSQLStorageConfig;
import org.moskito.central.storage.psql.entities.JSONStatisticsEntity;
import org.moskito.central.storage.psql.entities.SnapshotEntity;
import org.moskito.central.storage.psql.entities.StatisticsEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSQLStorage
implements Storage {
    private static final String PERSISTENCE_UNIT_NAME = "snapshotStorage";
    private static Logger log = LoggerFactory.getLogger(PSQLStorage.class);
    private PSQLStorageConfig config;
    private EntityManagerFactory factory;

    public void configure(String configurationName) {
        this.config = new PSQLStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Couldn't configure PSQLStorage with " + configurationName + " , working with default values");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.persistence.jdbc.driver", this.config.getDriver());
        map.put("javax.persistence.jdbc.url", this.config.getUrl());
        map.put("javax.persistence.jdbc.user", this.config.getUserName());
        map.put("javax.persistence.jdbc.password", this.config.getPassword());
        if (this.config.getHibernateDialect() != null) {
            map.put("hibernate.dialect", this.config.getHibernateDialect());
        }
        map.put("hibernate.hbm2ddl.auto", "update");
        map.put("hibernate.show_sql", "true");
        try {
            this.factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, map);
        }
        catch (PersistenceException e) {
            log.error("Persistence.createEntityManagerFactory({}, ({})", new Object[]{PERSISTENCE_UNIT_NAME, map, e});
        }
    }

    public void processSnapshot(Snapshot target) {
        String interval;
        String producerId = target.getMetaData().getProducerId();
        if (!this.config.include(producerId, interval = target.getMetaData().getIntervalName())) {
            return;
        }
        Class<? extends StatisticsEntity> statEntityClass = this.config.getStatEntityClassName(target.getMetaData().getStatClassName(), producerId);
        if (statEntityClass == null) {
            statEntityClass = JSONStatisticsEntity.class;
        }
        SnapshotEntity entity = new SnapshotEntity();
        entity.setProducerId(producerId);
        entity.setCategory(target.getMetaData().getCategory());
        entity.setSubsystem(target.getMetaData().getSubsystem());
        entity.setIntervalName(interval);
        entity.setComponentName(target.getMetaData().getComponentName());
        entity.setHostName(target.getMetaData().getHostName());
        entity.setCreationTimestamp(target.getMetaData().getCreationTimestamp());
        for (String key : target.getKeySet()) {
            StatisticsEntity entityInstance = null;
            try {
                entityInstance = statEntityClass.newInstance();
            }
            catch (IllegalAccessException e) {
                log.error("Instance cannot be instantiated", (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                log.error("Instance cannot be instantiated", (Throwable)e);
                continue;
            }
            entityInstance.setStats(target.getStatistics(key));
            entity.addStatistics(key, entityInstance);
        }
        EntityTransaction tr = null;
        try (EntityManager manager = null;){
            try {
                manager = this.factory.createEntityManager();
                tr = manager.getTransaction();
                tr.begin();
                manager.persist((Object)entity);
                tr.commit();
            }
            catch (Exception e) {
                log.error("persist failed", (Throwable)e);
                if (tr != null) {
                    tr.rollback();
                }
                if (manager != null) {
                    manager.close();
                }
            }
        }
    }
}

